/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.image.publisher;

import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.kafka.image.loader.LoaderManifest;

public class K2KRaftMetadataPublisherHelper<I, D> {
    private I lastSeenKRaftImage;
    private final Supplier<D> emptyKRaftDeltaSupplier;
    private final BiFunction<I, D, Boolean> kRaftChangeFilter;
    private final BiFunction<I, D, String> kRaftChangeDescriptionCreator;
    private K2TopicsImageAndVersion prevSeenK2TopicsImageAndVersion = K2TopicsImageAndVersion.empty();
    private K2TopicsImageAndVersion lastSeenK2TopicsImageAndVersion = K2TopicsImageAndVersion.empty();
    private final BiFunction<K2TopicsImageAndVersion, K2TopicsImageAndVersion, Boolean> k2ChangeFilter;
    private final Callback<I, D> callback;

    public K2KRaftMetadataPublisherHelper(I emptyKRaftImage, Supplier<D> emptyKRaftDeltaSupplier, BiFunction<I, D, Boolean> kRaftChangeFilter, BiFunction<I, D, String> kRaftChangeDescriptionCreator, BiFunction<K2TopicsImageAndVersion, K2TopicsImageAndVersion, Boolean> k2ChangeFilter, Callback<I, D> callback) {
        this.lastSeenKRaftImage = Objects.requireNonNull(emptyKRaftImage);
        this.emptyKRaftDeltaSupplier = Objects.requireNonNull(emptyKRaftDeltaSupplier);
        this.kRaftChangeFilter = Objects.requireNonNull(kRaftChangeFilter);
        this.kRaftChangeDescriptionCreator = Objects.requireNonNull(kRaftChangeDescriptionCreator);
        this.k2ChangeFilter = Objects.requireNonNull(k2ChangeFilter);
        this.callback = Objects.requireNonNull(callback);
    }

    public synchronized void maybePublishKRaftImageAndDelta(I currentKRaftImage, D currentKRaftDelta, LoaderManifest manifest) {
        this.lastSeenKRaftImage = Objects.requireNonNull(currentKRaftImage);
        if (this.kRaftChangeFilter.apply(currentKRaftImage, currentKRaftDelta).booleanValue()) {
            this.callback.doPublish(currentKRaftImage, currentKRaftDelta, manifest, this.prevSeenK2TopicsImageAndVersion, this.lastSeenK2TopicsImageAndVersion, true, this.kRaftChangeDescriptionCreator.apply(currentKRaftImage, currentKRaftDelta));
        }
    }

    public synchronized void maybePublishK2ImageAndVersion(K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        Objects.requireNonNull(currentK2TopicsImageAndVersion, "current K2 topics image and version instance must not be null (should not happen)");
        this.prevSeenK2TopicsImageAndVersion = this.lastSeenK2TopicsImageAndVersion;
        this.lastSeenK2TopicsImageAndVersion = currentK2TopicsImageAndVersion;
        if (this.k2ChangeFilter.apply(this.prevSeenK2TopicsImageAndVersion, currentK2TopicsImageAndVersion).booleanValue()) {
            this.callback.doPublish(this.lastSeenKRaftImage, this.emptyKRaftDeltaSupplier.get(), null, this.prevSeenK2TopicsImageAndVersion, currentK2TopicsImageAndVersion, false, "K2 image at (local, soft-state) topics version " + currentK2TopicsImageAndVersion.topicIdToNameVersion() + " and assignments version " + currentK2TopicsImageAndVersion.assignmentsVersion());
        }
    }

    public static interface Callback<I, D> {
        public void doPublish(I var1, D var2, LoaderManifest var3, K2TopicsImageAndVersion var4, K2TopicsImageAndVersion var5, boolean var6, String var7);
    }
}

