/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.net.InetAddress;
import java.util.Map;
import org.apache.kafka.network.ConnectionQuotaEntity;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.GenericConnectionQuotaEntity;
import org.apache.kafka.network.IpConnectionThrottledException;

public class IpQuotaEntity
implements ConnectionQuotaEntity,
GenericConnectionQuotaEntity {
    private final InetAddress ip;

    public IpQuotaEntity(InetAddress ip) {
        this.ip = ip;
    }

    @Override
    public String rateSensorName() {
        return "Connection-Accept-Rate-" + this.ip.getHostAddress();
    }

    @Override
    public String countSensorName() {
        return "Connection-Count-" + this.ip.getHostAddress();
    }

    @Override
    public long sensorExpiration() {
        return INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS;
    }

    @Override
    public String quotaMetricName() {
        return "connection-tokens";
    }

    @Override
    public String countMetricName() {
        return "authenticated-unthrottled-connection-count";
    }

    @Override
    public Map<String, String> metricTags() {
        return Map.of("ip", this.ip.getHostAddress());
    }

    @Override
    public String domain() {
        return "ip";
    }

    @Override
    public String entityName() {
        return this.ip.getHostAddress();
    }

    @Override
    public ConnectionThrottledException throttledException(String ip, long startThrottleTimeMs, long throttleTimeMs) {
        return new IpConnectionThrottledException(ip, startThrottleTimeMs, throttleTimeMs);
    }
}

