/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.network.metrics.RequestMetrics;

public class RequestChannelMetrics {
    private final Map<String, RequestMetrics> metricsMap = new HashMap<String, RequestMetrics>();
    public final Map<String, RequestMetrics.TenantRequestMetrics> tenantRequestMetricsMap = new ConcurrentHashMap<String, RequestMetrics.TenantRequestMetrics>();

    public RequestChannelMetrics(Set<ApiKeys> enabledApis) {
        for (ApiKeys apiKey : enabledApis) {
            this.metricsMap.put(apiKey.name, new RequestMetrics(apiKey.name));
        }
        for (String name : Arrays.asList(RequestMetrics.CONSUMER_FETCH_METRIC_NAME, RequestMetrics.FOLLOW_FETCH_METRIC_NAME, RequestMetrics.VERIFY_PARTITIONS_IN_TXN_METRIC_NAME, "ListClientMetricsResources")) {
            this.metricsMap.put(name, new RequestMetrics(name));
        }
    }

    public RequestChannelMetrics(ApiMessageType.ListenerType scope) {
        this(ApiKeys.apisForListener((ApiMessageType.ListenerType)scope));
    }

    public RequestMetrics apply(String metricName) {
        RequestMetrics requestMetrics = this.metricsMap.get(metricName);
        if (requestMetrics == null) {
            throw new NoSuchElementException("No RequestMetrics for " + metricName);
        }
        return requestMetrics;
    }

    public void close() {
        for (RequestMetrics requestMetrics : this.metricsMap.values()) {
            requestMetrics.removeMetrics();
        }
        for (RequestMetrics.TenantRequestMetrics tenantRequestMetrics : this.tenantRequestMetricsMap.values()) {
            tenantRequestMetrics.removeTenantLatencyMetric();
        }
        this.tenantRequestMetricsMap.clear();
    }
}

