/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class AclEntry {
    public static final KafkaPrincipal WILDCARD_PRINCIPAL = new KafkaPrincipal("User", "*");
    public static final String WILDCARD_PRINCIPAL_STRING = WILDCARD_PRINCIPAL.toString();
    public static final String WILDCARD_HOST = "*";
    public static final String WILDCARD_RESOURCE = "*";
    public static final Set<AclOperation> ACL_OPERATIONS = Arrays.stream(AclOperation.values()).filter(t -> t != AclOperation.UNKNOWN && t != AclOperation.ANY).collect(Collectors.toSet());

    public static Set<AclOperation> supportedOperations(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return new HashSet<AclOperation>(List.of(AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));
            }
            case GROUP: {
                return new HashSet<AclOperation>(List.of(AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));
            }
            case CLUSTER: {
                return new HashSet<AclOperation>(List.of(AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE));
            }
            case TRANSACTIONAL_ID: {
                return Set.of(AclOperation.DESCRIBE, AclOperation.WRITE, AclOperation.TWO_PHASE_COMMIT);
            }
            case DELEGATION_TOKEN: {
                return Set.of(AclOperation.DESCRIBE);
            }
            case USER: {
                return new HashSet<AclOperation>(List.of(AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS));
            }
        }
        throw new IllegalArgumentException("Not a concrete resource type");
    }

    public static Errors authorizationError(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return Errors.TOPIC_AUTHORIZATION_FAILED;
            }
            case GROUP: {
                return Errors.GROUP_AUTHORIZATION_FAILED;
            }
            case CLUSTER: {
                return Errors.CLUSTER_AUTHORIZATION_FAILED;
            }
            case TRANSACTIONAL_ID: {
                return Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED;
            }
            case DELEGATION_TOKEN: {
                return Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED;
            }
        }
        throw new IllegalArgumentException("Authorization error type not known");
    }
}

