/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;

public class ShareFetch {
    private final CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future;
    private final FetchParams fetchParams;
    private final String groupId;
    private final String memberId;
    private final List<TopicIdPartition> topicIdPartitions;
    private final int batchSize;
    private final int maxFetchRecords;
    private final int tierMaxPartitionFetchBytesOverride;
    private final BrokerTopicStats brokerTopicStats;
    private Map<TopicIdPartition, Throwable> erroneous;

    public ShareFetch(FetchParams fetchParams, String groupId, String memberId, CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future, List<TopicIdPartition> topicIdPartitions, int batchSize, int maxFetchRecords, int tierMaxPartitionFetchBytesOverride, BrokerTopicStats brokerTopicStats) {
        this.fetchParams = fetchParams;
        this.groupId = groupId;
        this.memberId = memberId;
        this.future = future;
        this.topicIdPartitions = topicIdPartitions;
        this.batchSize = batchSize;
        this.maxFetchRecords = maxFetchRecords;
        this.tierMaxPartitionFetchBytesOverride = tierMaxPartitionFetchBytesOverride;
        this.brokerTopicStats = brokerTopicStats;
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<TopicIdPartition> topicIdPartitions() {
        return this.topicIdPartitions;
    }

    public FetchParams fetchParams() {
        return this.fetchParams;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int maxFetchRecords() {
        return this.maxFetchRecords;
    }

    public int tierMaxPartitionFetchBytesOverride() {
        return this.tierMaxPartitionFetchBytesOverride;
    }

    public synchronized void addErroneous(TopicIdPartition topicIdPartition, Throwable throwable) {
        if (this.erroneous == null) {
            this.erroneous = new HashMap<TopicIdPartition, Throwable>();
        }
        this.erroneous.put(topicIdPartition, throwable);
    }

    public boolean isCompleted() {
        return this.future.isDone();
    }

    public synchronized boolean errorInAllPartitions() {
        return this.erroneous != null && this.erroneous.size() == this.topicIdPartitions().size();
    }

    public void maybeComplete(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> partitionData) {
        if (this.isCompleted()) {
            return;
        }
        HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> response = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>(partitionData);
        this.addErroneousToResponse(response);
        this.future.complete(response);
    }

    public void maybeCompleteWithException(Collection<TopicIdPartition> topicIdPartitions, Throwable throwable) {
        if (this.isCompleted()) {
            return;
        }
        HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> response = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        topicIdPartitions.forEach(tp -> this.addErroneous((TopicIdPartition)tp, throwable));
        this.addErroneousToResponse(response);
        this.future.complete(response);
    }

    public synchronized Set<TopicIdPartition> filterErroneousTopicPartitions(Set<TopicIdPartition> topicIdPartitions) {
        if (this.erroneous != null) {
            LinkedHashSet<TopicIdPartition> retain = new LinkedHashSet<TopicIdPartition>(topicIdPartitions);
            retain.removeAll(this.erroneous.keySet());
            return retain;
        }
        return topicIdPartitions;
    }

    private synchronized void addErroneousToResponse(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> response) {
        if (this.erroneous != null) {
            HashSet erroneousTopics = new HashSet();
            this.erroneous.forEach((topicIdPartition, throwable) -> {
                erroneousTopics.add(topicIdPartition.topic());
                response.put((TopicIdPartition)topicIdPartition, new ShareFetchResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable.getMessage()).setRecords((BaseRecords)MemoryRecords.EMPTY));
            });
            erroneousTopics.forEach(topic -> {
                this.brokerTopicStats.allTopicsStats().failedShareFetchRequestRate().mark();
                this.brokerTopicStats.topicStats(topic).failedShareFetchRequestRate().mark();
            });
        }
    }
}

