/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.backupRestore.objectLifecycle.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.BlobMetadata;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TopicMetadata
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static TopicMetadata getRootAsTopicMetadata(ByteBuffer _bb) {
        return TopicMetadata.getRootAsTopicMetadata(_bb, new TopicMetadata());
    }

    public static TopicMetadata getRootAsTopicMetadata(ByteBuffer _bb, TopicMetadata obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TopicMetadata __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String name() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer nameAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer nameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String id() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer idAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer idInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int partition() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public BlobMetadata blobs(int j) {
        return this.blobs(new BlobMetadata(), j);
    }

    public BlobMetadata blobs(BlobMetadata obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int blobsLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public BlobMetadata.Vector blobsVector() {
        return this.blobsVector(new BlobMetadata.Vector());
    }

    public BlobMetadata.Vector blobsVector(BlobMetadata.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createTopicMetadata(FlatBufferBuilder builder, int nameOffset, int idOffset, int partition, int blobsOffset) {
        builder.startTable(4);
        TopicMetadata.addBlobs(builder, blobsOffset);
        TopicMetadata.addPartition(builder, partition);
        TopicMetadata.addId(builder, idOffset);
        TopicMetadata.addName(builder, nameOffset);
        return TopicMetadata.endTopicMetadata(builder);
    }

    public static void startTopicMetadata(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addName(FlatBufferBuilder builder, int nameOffset) {
        builder.addOffset(0, nameOffset, 0);
    }

    public static void addId(FlatBufferBuilder builder, int idOffset) {
        builder.addOffset(1, idOffset, 0);
    }

    public static void addPartition(FlatBufferBuilder builder, int partition) {
        builder.addInt(2, partition, 0);
    }

    public static void addBlobs(FlatBufferBuilder builder, int blobsOffset) {
        builder.addOffset(3, blobsOffset, 0);
    }

    public static int createBlobsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startBlobsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endTopicMetadata(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TopicMetadata get(int j) {
            return this.get(new TopicMetadata(), j);
        }

        public TopicMetadata get(TopicMetadata obj, int j) {
            return obj.__assign(TopicMetadata.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

