/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.HashMap;
import java.util.Map;

public enum Algorithm {
    ADLER(".adler", (byte)1),
    NO_CHECKSUM("", (byte)2);

    public final String suffix;
    public final Byte id;
    private static final Map<String, Algorithm> SUFFIXES;
    private static final Map<Byte, Algorithm> IDS;

    private Algorithm(String suffix, Byte id) {
        this.suffix = suffix;
        this.id = id;
    }

    public static Algorithm toAlgorithm(String suffix) {
        return SUFFIXES.get(suffix);
    }

    public static Algorithm toAlgorithm(Byte id) {
        return IDS.get(id);
    }

    static {
        SUFFIXES = new HashMap<String, Algorithm>();
        IDS = new HashMap<Byte, Algorithm>();
        for (Algorithm algorithm : Algorithm.values()) {
            SUFFIXES.put(algorithm.suffix, algorithm);
            IDS.put(algorithm.id, algorithm);
        }
    }
}

