/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.CompactStats;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.UUID;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class CompactionCommitAndSwap
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static CompactionCommitAndSwap getRootAsCompactionCommitAndSwap(ByteBuffer _bb) {
        return CompactionCommitAndSwap.getRootAsCompactionCommitAndSwap(_bb, new CompactionCommitAndSwap());
    }

    public static CompactionCommitAndSwap getRootAsCompactionCommitAndSwap(ByteBuffer _bb, CompactionCommitAndSwap obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public CompactionCommitAndSwap __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public int tierEpoch() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.stateOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch stateOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public UUID messageId() {
        return this.messageId(new UUID());
    }

    public UUID messageId(UUID obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public UUID sourceObjectIds(int j) {
        return this.sourceObjectIds(new UUID(), j);
    }

    public UUID sourceObjectIds(UUID obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int sourceObjectIdsLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public UUID.Vector sourceObjectIdsVector() {
        return this.sourceObjectIdsVector(new UUID.Vector());
    }

    public UUID.Vector sourceObjectIdsVector(UUID.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 16, this.bb) : null;
    }

    public UUID destinationObjectIds(int j) {
        return this.destinationObjectIds(new UUID(), j);
    }

    public UUID destinationObjectIds(UUID obj, int j) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int destinationObjectIdsLength() {
        int o = this.__offset(14);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public UUID.Vector destinationObjectIdsVector() {
        return this.destinationObjectIdsVector(new UUID.Vector());
    }

    public UUID.Vector destinationObjectIdsVector(UUID.Vector obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__vector(o), 16, this.bb) : null;
    }

    public long lastCleanOffset() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public CompactStats compactStats() {
        return this.compactStats(new CompactStats());
    }

    public CompactStats compactStats(CompactStats obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long firstCleanOffset() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public static void startCompactionCommitAndSwap(FlatBufferBuilder builder) {
        builder.startTable(9);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addTierEpoch(FlatBufferBuilder builder, int tierEpoch) {
        builder.addInt(1, tierEpoch, 0);
    }

    public static void addStateOffsetAndEpoch(FlatBufferBuilder builder, int stateOffsetAndEpochOffset) {
        builder.addStruct(2, stateOffsetAndEpochOffset, 0);
    }

    public static void addMessageId(FlatBufferBuilder builder, int messageIdOffset) {
        builder.addStruct(3, messageIdOffset, 0);
    }

    public static void addSourceObjectIds(FlatBufferBuilder builder, int sourceObjectIdsOffset) {
        builder.addOffset(4, sourceObjectIdsOffset, 0);
    }

    public static void startSourceObjectIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static void addDestinationObjectIds(FlatBufferBuilder builder, int destinationObjectIdsOffset) {
        builder.addOffset(5, destinationObjectIdsOffset, 0);
    }

    public static void startDestinationObjectIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static void addLastCleanOffset(FlatBufferBuilder builder, long lastCleanOffset) {
        builder.addLong(6, lastCleanOffset, 0L);
    }

    public static void addCompactStats(FlatBufferBuilder builder, int compactStatsOffset) {
        builder.addStruct(7, compactStatsOffset, 0);
    }

    public static void addFirstCleanOffset(FlatBufferBuilder builder, long firstCleanOffset) {
        builder.addLong(8, firstCleanOffset, -1L);
    }

    public static int endCompactionCommitAndSwap(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishCompactionCommitAndSwapBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedCompactionCommitAndSwapBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public CompactionCommitAndSwap get(int j) {
            return this.get(new CompactionCommitAndSwap(), j);
        }

        public CompactionCommitAndSwap get(CompactionCommitAndSwap obj, int j) {
            return obj.__assign(CompactionCommitAndSwap.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

