/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.serdes.OpaqueDataField;
import io.confluent.kafka.storage.tier.serdes.UUID;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TierPartitionStateEntry
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static TierPartitionStateEntry getRootAsTierPartitionStateEntry(ByteBuffer _bb) {
        return TierPartitionStateEntry.getRootAsTierPartitionStateEntry(_bb, new TierPartitionStateEntry());
    }

    public static TierPartitionStateEntry getRootAsTierPartitionStateEntry(ByteBuffer _bb, TierPartitionStateEntry obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TierPartitionStateEntry __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateVersion(byte version) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, version);
            return true;
        }
        return false;
    }

    public int tierEpoch() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateTierEpoch(int tier_epoch) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, tier_epoch);
            return true;
        }
        return false;
    }

    public UUID objectId() {
        return this.objectId(new UUID());
    }

    public UUID objectId(UUID obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long baseOffset() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateBaseOffset(long base_offset) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, base_offset);
            return true;
        }
        return false;
    }

    public int endOffsetDelta() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateEndOffsetDelta(int end_offset_delta) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, end_offset_delta);
            return true;
        }
        return false;
    }

    public long maxTimestamp() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateMaxTimestamp(long max_timestamp) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, max_timestamp);
            return true;
        }
        return false;
    }

    public int size() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateSize(int size) {
        int o = this.__offset(16);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, size);
            return true;
        }
        return false;
    }

    public byte state() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateState(byte state) {
        int o = this.__offset(18);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, state);
            return true;
        }
        return false;
    }

    public boolean hasEpochState() {
        int o = this.__offset(20);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateHasEpochState(boolean has_epoch_state) {
        int o = this.__offset(20);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(has_epoch_state ? 1 : 0));
            return true;
        }
        return false;
    }

    public boolean hasAbortedTxns() {
        int o = this.__offset(22);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateHasAbortedTxns(boolean has_aborted_txns) {
        int o = this.__offset(22);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(has_aborted_txns ? 1 : 0));
            return true;
        }
        return false;
    }

    public boolean hasProducerState() {
        int o = this.__offset(24);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateHasProducerState(boolean has_producer_state) {
        int o = this.__offset(24);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(has_producer_state ? 1 : 0));
            return true;
        }
        return false;
    }

    public OpaqueDataField opaqueData() {
        return this.opaqueData(new OpaqueDataField());
    }

    public OpaqueDataField opaqueData(OpaqueDataField obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long firstBatchTimestamp() {
        int o = this.__offset(28);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateFirstBatchTimestamp(long first_batch_timestamp) {
        int o = this.__offset(28);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, first_batch_timestamp);
            return true;
        }
        return false;
    }

    public byte uploadType() {
        int o = this.__offset(30);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateUploadType(byte upload_type) {
        int o = this.__offset(30);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, upload_type);
            return true;
        }
        return false;
    }

    public long stateChangeTimestamp() {
        int o = this.__offset(32);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateStateChangeTimestamp(long state_change_timestamp) {
        int o = this.__offset(32);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, state_change_timestamp);
            return true;
        }
        return false;
    }

    public int virtualBaseOffsetDelta() {
        int o = this.__offset(34);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : -1;
    }

    public boolean mutateVirtualBaseOffsetDelta(int virtual_base_offset_delta) {
        int o = this.__offset(34);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, virtual_base_offset_delta);
            return true;
        }
        return false;
    }

    public byte stateBeforeDeletion() {
        int o = this.__offset(36);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)-1;
    }

    public boolean mutateStateBeforeDeletion(byte state_before_deletion) {
        int o = this.__offset(36);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, state_before_deletion);
            return true;
        }
        return false;
    }

    public FragmentDescription segmentAndMetadataLayout(int j) {
        return this.segmentAndMetadataLayout(new FragmentDescription(), j);
    }

    public FragmentDescription segmentAndMetadataLayout(FragmentDescription obj, int j) {
        int o = this.__offset(38);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int segmentAndMetadataLayoutLength() {
        int o = this.__offset(38);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public FragmentDescription.Vector segmentAndMetadataLayoutVector() {
        return this.segmentAndMetadataLayoutVector(new FragmentDescription.Vector());
    }

    public FragmentDescription.Vector segmentAndMetadataLayoutVector(FragmentDescription.Vector obj) {
        int o = this.__offset(38);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public byte encryptedDek(int j) {
        int o = this.__offset(40);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int encryptedDekLength() {
        int o = this.__offset(40);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector encryptedDekVector() {
        return this.encryptedDekVector(new ByteVector());
    }

    public ByteVector encryptedDekVector(ByteVector obj) {
        int o = this.__offset(40);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer encryptedDekAsByteBuffer() {
        return this.__vector_as_bytebuffer(40, 1);
    }

    public ByteBuffer encryptedDekInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 40, 1);
    }

    public boolean mutateEncryptedDek(int j, byte encrypted_dek) {
        int o = this.__offset(40);
        if (o != 0) {
            this.bb.put(this.__vector(o) + j * 1, encrypted_dek);
            return true;
        }
        return false;
    }

    public static void startTierPartitionStateEntry(FlatBufferBuilder builder) {
        builder.startTable(19);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addTierEpoch(FlatBufferBuilder builder, int tierEpoch) {
        builder.addInt(1, tierEpoch, 0);
    }

    public static void addObjectId(FlatBufferBuilder builder, int objectIdOffset) {
        builder.addStruct(2, objectIdOffset, 0);
    }

    public static void addBaseOffset(FlatBufferBuilder builder, long baseOffset) {
        builder.addLong(3, baseOffset, 0L);
    }

    public static void addEndOffsetDelta(FlatBufferBuilder builder, int endOffsetDelta) {
        builder.addInt(4, endOffsetDelta, 0);
    }

    public static void addMaxTimestamp(FlatBufferBuilder builder, long maxTimestamp) {
        builder.addLong(5, maxTimestamp, 0L);
    }

    public static void addSize(FlatBufferBuilder builder, int size) {
        builder.addInt(6, size, 0);
    }

    public static void addState(FlatBufferBuilder builder, byte state) {
        builder.addByte(7, state, 0);
    }

    public static void addHasEpochState(FlatBufferBuilder builder, boolean hasEpochState) {
        builder.addBoolean(8, hasEpochState, false);
    }

    public static void addHasAbortedTxns(FlatBufferBuilder builder, boolean hasAbortedTxns) {
        builder.addBoolean(9, hasAbortedTxns, false);
    }

    public static void addHasProducerState(FlatBufferBuilder builder, boolean hasProducerState) {
        builder.addBoolean(10, hasProducerState, false);
    }

    public static void addOpaqueData(FlatBufferBuilder builder, int opaqueDataOffset) {
        builder.addStruct(11, opaqueDataOffset, 0);
    }

    public static void addFirstBatchTimestamp(FlatBufferBuilder builder, long firstBatchTimestamp) {
        builder.addLong(12, firstBatchTimestamp, -1L);
    }

    public static void addUploadType(FlatBufferBuilder builder, byte uploadType) {
        builder.addByte(13, uploadType, 0);
    }

    public static void addStateChangeTimestamp(FlatBufferBuilder builder, long stateChangeTimestamp) {
        builder.addLong(14, stateChangeTimestamp, -1L);
    }

    public static void addVirtualBaseOffsetDelta(FlatBufferBuilder builder, int virtualBaseOffsetDelta) {
        builder.addInt(15, virtualBaseOffsetDelta, -1);
    }

    public static void addStateBeforeDeletion(FlatBufferBuilder builder, byte stateBeforeDeletion) {
        builder.addByte(16, stateBeforeDeletion, -1);
    }

    public static void addSegmentAndMetadataLayout(FlatBufferBuilder builder, int segmentAndMetadataLayoutOffset) {
        builder.addOffset(17, segmentAndMetadataLayoutOffset, 0);
    }

    public static int createSegmentAndMetadataLayoutVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startSegmentAndMetadataLayoutVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addEncryptedDek(FlatBufferBuilder builder, int encryptedDekOffset) {
        builder.addOffset(18, encryptedDekOffset, 0);
    }

    public static int createEncryptedDekVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createEncryptedDekVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startEncryptedDekVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endTierPartitionStateEntry(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishTierPartitionStateEntryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedTierPartitionStateEntryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TierPartitionStateEntry get(int j) {
            return this.get(new TierPartitionStateEntry(), j);
        }

        public TierPartitionStateEntry get(TierPartitionStateEntry obj, int j) {
            return obj.__assign(TierPartitionStateEntry.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

