/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.CompactStats;
import io.confluent.kafka.storage.tier.serdes.MaterializationTrackingInfo;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.SnapshotTrackingInfo;
import io.confluent.kafka.storage.tier.serdes.UUID;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TierPartitionStateHeader
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static TierPartitionStateHeader getRootAsTierPartitionStateHeader(ByteBuffer _bb) {
        return TierPartitionStateHeader.getRootAsTierPartitionStateHeader(_bb, new TierPartitionStateHeader());
    }

    public static TierPartitionStateHeader getRootAsTierPartitionStateHeader(ByteBuffer _bb, TierPartitionStateHeader obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TierPartitionStateHeader __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateVersion(byte version) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, version);
            return true;
        }
        return false;
    }

    public UUID topicId() {
        return this.topicId(new UUID());
    }

    public UUID topicId(UUID obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int tierEpoch() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateTierEpoch(int tier_epoch) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, tier_epoch);
            return true;
        }
        return false;
    }

    public byte status() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateStatus(byte status) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, status);
            return true;
        }
        return false;
    }

    public long endOffset() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateEndOffset(long end_offset) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, end_offset);
            return true;
        }
        return false;
    }

    public MaterializationTrackingInfo materializationInfo() {
        return this.materializationInfo(new MaterializationTrackingInfo());
    }

    public MaterializationTrackingInfo materializationInfo(MaterializationTrackingInfo obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public OffsetAndEpoch errorOffsetAndEpoch() {
        return this.errorOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch errorOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public OffsetAndEpoch restoreOffsetAndEpoch() {
        return this.restoreOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch restoreOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long startOffset() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateStartOffset(long start_offset) {
        int o = this.__offset(20);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, start_offset);
            return true;
        }
        return false;
    }

    public long compactDirtyStartOffset() {
        int o = this.__offset(22);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateCompactDirtyStartOffset(long compact_dirty_start_offset) {
        int o = this.__offset(22);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, compact_dirty_start_offset);
            return true;
        }
        return false;
    }

    public CompactStats lastCompactStats() {
        return this.lastCompactStats(new CompactStats());
    }

    public CompactStats lastCompactStats(CompactStats obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public CompactStats accumulatedCompactStats() {
        return this.accumulatedCompactStats(new CompactStats());
    }

    public CompactStats accumulatedCompactStats(CompactStats obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public boolean hasStateChangeTimestamp() {
        int o = this.__offset(28);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateHasStateChangeTimestamp(boolean has_state_change_timestamp) {
        int o = this.__offset(28);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(has_state_change_timestamp ? 1 : 0));
            return true;
        }
        return false;
    }

    public SnapshotTrackingInfo snapshotInfo() {
        return this.snapshotInfo(new SnapshotTrackingInfo());
    }

    public SnapshotTrackingInfo snapshotInfo(SnapshotTrackingInfo obj) {
        int o = this.__offset(30);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public static void startTierPartitionStateHeader(FlatBufferBuilder builder) {
        builder.startTable(14);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addTopicId(FlatBufferBuilder builder, int topicIdOffset) {
        builder.addStruct(1, topicIdOffset, 0);
    }

    public static void addTierEpoch(FlatBufferBuilder builder, int tierEpoch) {
        builder.addInt(2, tierEpoch, 0);
    }

    public static void addStatus(FlatBufferBuilder builder, byte status) {
        builder.addByte(3, status, 0);
    }

    public static void addEndOffset(FlatBufferBuilder builder, long endOffset) {
        builder.addLong(4, endOffset, -1L);
    }

    public static void addMaterializationInfo(FlatBufferBuilder builder, int materializationInfoOffset) {
        builder.addOffset(5, materializationInfoOffset, 0);
    }

    public static void addErrorOffsetAndEpoch(FlatBufferBuilder builder, int errorOffsetAndEpochOffset) {
        builder.addStruct(6, errorOffsetAndEpochOffset, 0);
    }

    public static void addRestoreOffsetAndEpoch(FlatBufferBuilder builder, int restoreOffsetAndEpochOffset) {
        builder.addStruct(7, restoreOffsetAndEpochOffset, 0);
    }

    public static void addStartOffset(FlatBufferBuilder builder, long startOffset) {
        builder.addLong(8, startOffset, -1L);
    }

    public static void addCompactDirtyStartOffset(FlatBufferBuilder builder, long compactDirtyStartOffset) {
        builder.addLong(9, compactDirtyStartOffset, -1L);
    }

    public static void addLastCompactStats(FlatBufferBuilder builder, int lastCompactStatsOffset) {
        builder.addStruct(10, lastCompactStatsOffset, 0);
    }

    public static void addAccumulatedCompactStats(FlatBufferBuilder builder, int accumulatedCompactStatsOffset) {
        builder.addStruct(11, accumulatedCompactStatsOffset, 0);
    }

    public static void addHasStateChangeTimestamp(FlatBufferBuilder builder, boolean hasStateChangeTimestamp) {
        builder.addBoolean(12, hasStateChangeTimestamp, false);
    }

    public static void addSnapshotInfo(FlatBufferBuilder builder, int snapshotInfoOffset) {
        builder.addOffset(13, snapshotInfoOffset, 0);
    }

    public static int endTierPartitionStateHeader(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishTierPartitionStateHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedTierPartitionStateHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TierPartitionStateHeader get(int j) {
            return this.get(new TierPartitionStateHeader(), j);
        }

        public TierPartitionStateHeader get(TierPartitionStateHeader obj, int j) {
            return obj.__assign(TierPartitionStateHeader.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

