/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.backupRestore.objectLifecycle.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.Header;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.TopicMetadata;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class BackupObjectsMetadata
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static BackupObjectsMetadata getRootAsBackupObjectsMetadata(ByteBuffer _bb) {
        return BackupObjectsMetadata.getRootAsBackupObjectsMetadata(_bb, new BackupObjectsMetadata());
    }

    public static BackupObjectsMetadata getRootAsBackupObjectsMetadata(ByteBuffer _bb, BackupObjectsMetadata obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public BackupObjectsMetadata __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public Header header() {
        return this.header(new Header());
    }

    public Header header(Header obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public TopicMetadata topics(int j) {
        return this.topics(new TopicMetadata(), j);
    }

    public TopicMetadata topics(TopicMetadata obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int topicsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public TopicMetadata.Vector topicsVector() {
        return this.topicsVector(new TopicMetadata.Vector());
    }

    public TopicMetadata.Vector topicsVector(TopicMetadata.Vector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createBackupObjectsMetadata(FlatBufferBuilder builder, int headerOffset, int topicsOffset) {
        builder.startTable(2);
        BackupObjectsMetadata.addTopics(builder, topicsOffset);
        BackupObjectsMetadata.addHeader(builder, headerOffset);
        return BackupObjectsMetadata.endBackupObjectsMetadata(builder);
    }

    public static void startBackupObjectsMetadata(FlatBufferBuilder builder) {
        builder.startTable(2);
    }

    public static void addHeader(FlatBufferBuilder builder, int headerOffset) {
        builder.addOffset(0, headerOffset, 0);
    }

    public static void addTopics(FlatBufferBuilder builder, int topicsOffset) {
        builder.addOffset(1, topicsOffset, 0);
    }

    public static int createTopicsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startTopicsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endBackupObjectsMetadata(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishBackupObjectsMetadataBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedBackupObjectsMetadataBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public BackupObjectsMetadata get(int j) {
            return this.get(new BackupObjectsMetadata(), j);
        }

        public BackupObjectsMetadata get(BackupObjectsMetadata obj, int j) {
            return obj.__assign(BackupObjectsMetadata.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

