/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.restore.db.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class PartitionRestoreContext
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static PartitionRestoreContext getRootAsPartitionRestoreContext(ByteBuffer _bb) {
        return PartitionRestoreContext.getRootAsPartitionRestoreContext(_bb, new PartitionRestoreContext());
    }

    public static PartitionRestoreContext getRootAsPartitionRestoreContext(ByteBuffer _bb, PartitionRestoreContext obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public PartitionRestoreContext __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String topic() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer topicInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public int partition() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int leader() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int replicas(int j) {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int replicasLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector replicasVector() {
        return this.replicasVector(new IntVector());
    }

    public IntVector replicasVector(IntVector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer replicasAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 4);
    }

    public ByteBuffer replicasInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 4);
    }

    public long restoreStartTime() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public int status() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int state() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public static int createPartitionRestoreContext(FlatBufferBuilder builder, int topicOffset, int partition, int leader, int replicasOffset, long restoreStartTime, int status, int state) {
        builder.startTable(7);
        PartitionRestoreContext.addRestoreStartTime(builder, restoreStartTime);
        PartitionRestoreContext.addState(builder, state);
        PartitionRestoreContext.addStatus(builder, status);
        PartitionRestoreContext.addReplicas(builder, replicasOffset);
        PartitionRestoreContext.addLeader(builder, leader);
        PartitionRestoreContext.addPartition(builder, partition);
        PartitionRestoreContext.addTopic(builder, topicOffset);
        return PartitionRestoreContext.endPartitionRestoreContext(builder);
    }

    public static void startPartitionRestoreContext(FlatBufferBuilder builder) {
        builder.startTable(7);
    }

    public static void addTopic(FlatBufferBuilder builder, int topicOffset) {
        builder.addOffset(0, topicOffset, 0);
    }

    public static void addPartition(FlatBufferBuilder builder, int partition) {
        builder.addInt(1, partition, 0);
    }

    public static void addLeader(FlatBufferBuilder builder, int leader) {
        builder.addInt(2, leader, 0);
    }

    public static void addReplicas(FlatBufferBuilder builder, int replicasOffset) {
        builder.addOffset(3, replicasOffset, 0);
    }

    public static int createReplicasVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startReplicasVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addRestoreStartTime(FlatBufferBuilder builder, long restoreStartTime) {
        builder.addLong(4, restoreStartTime, 0L);
    }

    public static void addStatus(FlatBufferBuilder builder, int status) {
        builder.addInt(5, status, 0);
    }

    public static void addState(FlatBufferBuilder builder, int state) {
        builder.addInt(6, state, 0);
    }

    public static int endPartitionRestoreContext(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public PartitionRestoreContext get(int j) {
            return this.get(new PartitionRestoreContext(), j);
        }

        public PartitionRestoreContext get(PartitionRestoreContext obj, int j) {
            return obj.__assign(PartitionRestoreContext.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

