/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.storage.checksum.ChecksumAlgorithm;
import io.confluent.kafka.storage.checksum.ChecksumHeader;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.E2EChecksumMetrics;
import io.confluent.kafka.storage.checksum.algorithms.Crc32cAlgorithms;
import java.nio.ByteBuffer;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32C;
import org.apache.kafka.common.utils.Time;

public class Crc32cChecksumStore
extends ChecksumStore {
    private static final int VERSION = 1;

    public Crc32cChecksumStore(long storeEntryTTL, Time time, ChecksumStoreReaderWriter storeReaderWriter, E2EChecksumMetrics metrics) {
        super(new ChecksumHeader(1, ChecksumAlgorithm.CRC32C), storeEntryTTL, time, storeReaderWriter, metrics);
    }

    @Override
    protected ChecksumAlgorithm algorithm() {
        return ChecksumAlgorithm.CRC32C;
    }

    @Override
    public Checksum emptyChecksum() {
        return new CRC32C();
    }

    @Override
    public Checksum convertLongToChecksum(long crcValue) {
        return Crc32C.create((int)((int)(crcValue ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    @Override
    protected Checksum truncate(Checksum checksum, ByteBuffer bytesToTruncate) {
        Checksum checksumForTruncatedBytes = Crc32C.create((int)0);
        int truncatedLength = bytesToTruncate.remaining();
        Checksums.update((Checksum)checksumForTruncatedBytes, (ByteBuffer)bytesToTruncate, (int)truncatedLength);
        int crcA0 = (int)(checksum.getValue() ^ checksumForTruncatedBytes.getValue());
        return Crc32cAlgorithms.removeZeros(crcA0, truncatedLength);
    }

    public Checksum combine(Checksum crc1, Checksum crc2, long len2) {
        long combined = Crc32cAlgorithms.combineCRC32C(crc1.getValue(), crc2.getValue(), len2);
        return this.convertLongToChecksum(combined);
    }
}

