/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum.algorithms;

import java.util.zip.Checksum;

public class CRC64
implements Checksum {
    private static final long POLY = -3932672073523589310L;
    private static final long[] TABLE = new long[256];
    private static final int GF2_DIM = 64;
    private long value;

    public CRC64() {
        this.value = 0L;
    }

    public CRC64(long value) {
        this.value = value;
    }

    public CRC64(byte[] b, int len) {
        this.value = 0L;
        this.update(b, len);
    }

    public static CRC64 fromBytes(byte[] b) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l ^= (long)b[i] & 0xFFL;
        }
        return new CRC64(l);
    }

    private static long gf2MatrixTimes(long[] mat, long vec) {
        long sum = 0L;
        int idx = 0;
        while (vec != 0L) {
            if ((vec & 1L) == 1L) {
                sum ^= mat[idx];
            }
            vec >>>= 1;
            ++idx;
        }
        return sum;
    }

    private static void gf2MatrixSquare(long[] square, long[] mat) {
        for (int n = 0; n < 64; ++n) {
            square[n] = CRC64.gf2MatrixTimes(mat, mat[n]);
        }
    }

    public static CRC64 combine(CRC64 summ1, CRC64 summ2, long len2) {
        if (len2 == 0L) {
            return new CRC64(summ1.getValue());
        }
        long[] even = new long[64];
        long[] odd = new long[64];
        odd[0] = -3932672073523589310L;
        long row = 1L;
        for (int n = 1; n < 64; ++n) {
            odd[n] = row;
            row <<= 1;
        }
        CRC64.gf2MatrixSquare(even, odd);
        CRC64.gf2MatrixSquare(odd, even);
        long crc1 = summ1.getValue();
        long crc2 = summ2.getValue();
        do {
            CRC64.gf2MatrixSquare(even, odd);
            if ((len2 & 1L) == 1L) {
                crc1 = CRC64.gf2MatrixTimes(even, crc1);
            }
            if ((len2 >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(odd, even);
            if ((len2 & 1L) != 1L) continue;
            crc1 = CRC64.gf2MatrixTimes(odd, crc1);
        } while ((len2 >>>= 1) != 0L);
        return new CRC64(crc1 ^= crc2);
    }

    public static long combine(long crc1, long crc2, long len2) {
        if (len2 == 0L) {
            return crc1;
        }
        long[] even = new long[64];
        long[] odd = new long[64];
        odd[0] = -3932672073523589310L;
        long row = 1L;
        for (int n = 1; n < 64; ++n) {
            odd[n] = row;
            row <<= 1;
        }
        CRC64.gf2MatrixSquare(even, odd);
        CRC64.gf2MatrixSquare(odd, even);
        do {
            CRC64.gf2MatrixSquare(even, odd);
            if ((len2 & 1L) == 1L) {
                crc1 = CRC64.gf2MatrixTimes(even, crc1);
            }
            if ((len2 >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(odd, even);
            if ((len2 & 1L) != 1L) continue;
            crc1 = CRC64.gf2MatrixTimes(odd, crc1);
        } while ((len2 >>>= 1) != 0L);
        return crc1 ^= crc2;
    }

    public byte[] getBytes() {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(this.value >>> i * 8);
        }
        return b;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public final void update(byte[] b, int len) {
        int idx = 0;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        while (len > 0) {
            this.value = TABLE[(int)(this.value ^ (long)b[idx]) & 0xFF] ^ this.value >>> 8;
            ++idx;
            --len;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    public void update(byte b) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        this.value = TABLE[(int)(this.value ^ (long)b) & 0xFF] ^ this.value >>> 8;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void update(int b) {
        this.update((byte)(b & 0xFF));
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i = off;
        while (len > 0) {
            this.update(b[i++]);
            --len;
        }
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            long crc = n;
            for (int k = 0; k < 8; ++k) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64.TABLE[n] = crc;
        }
    }
}

