/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.log;

import io.confluent.kafka.storage.TierState;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.common.UnexpectedAppendEpochException;
import io.confluent.kafka.storage.log.FollowerLog;
import io.confluent.kafka.storage.log.LogDivergenceResult;
import io.confluent.kafka.storage.log.LogSizeDetails;
import io.confluent.kafka.storage.log.ResolveRangesResult;
import io.confluent.kafka.storage.log.TierLogSegment;
import io.confluent.kafka.storage.log.UploadableSegment;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FollowerRestorePoint;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.MaybeResolvedTimestampAndOffset;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.VerificationGuard;

public interface AbstractLog
extends AutoCloseable,
FollowerLog {
    public File dir();

    public String parentDir();

    public File parentDirFile();

    @Override
    public Optional<Uuid> topicId();

    public Optional<PartitionMetadataFile> partitionMetadataFile();

    @Override
    public LogConfig config();

    @Override
    public long logStartOffset();

    public long localLogStartOffset();

    public FollowerRestorePoint localLogStartOffsetAndFollowerRestorePoint();

    public long localLogEndOffset();

    public long recoveryPoint();

    public boolean hasLogDivergence();

    public LogDivergenceResult detectLogDivergence();

    @Override
    public TopicPartition topicPartition();

    public String name();

    public boolean isFuture();

    public boolean isDeleted();

    public boolean isStray();

    public LeaderEpochFileCache leaderEpochCache();

    public Optional<Long> firstUnstableOffset();

    public long lastStableOffset();

    public long lastStableOffsetLag();

    public List<DescribeProducersResponseData.ProducerState> activeProducers();

    public boolean hasLateTransaction(long var1);

    public int producerIdCount();

    public int numberOfSegments();

    public Collection<LogSegment> localLogSegments();

    public Collection<LogSegment> localLogSegments(long var1, long var3);

    public Collection<LogSegment> localNonActiveLogSegmentsFrom(long var1);

    public Iterator<TierLogSegment> tieredLogSegments();

    public Iterator<TierLogSegment> tieredLogSegments(long var1, long var3);

    public Iterable<LogSegment> tierableLogSegments();

    public boolean isRebuildingTierState(long var1);

    public boolean isTierMetadataStateRecovering();

    public boolean isTierCompactable();

    public boolean remoteLogEnabled();

    public void updateHighestOffsetInRemoteStorage(long var1);

    public void updateLogStartOffsetFromRemoteTier(long var1);

    public boolean isLocallyCompactable();

    public boolean isFrozenLogStartOffsetState();

    public Optional<Long> baseOffsetFirstUntierableSegment();

    public LogSegment activeSegment();

    @Override
    public void close();

    public void renameDir(String var1, boolean var2) throws KafkaStorageException;

    public void closeHandlers();

    public LogAppendInfo appendAsLeader(MemoryRecords var1, int var2, AppendOrigin var3, RequestLocal var4, VerificationGuard var5) throws KafkaStorageException;

    default public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, RequestLocal requestLocal) throws KafkaStorageException {
        return this.appendAsLeader(records, leaderEpoch, origin, requestLocal, VerificationGuard.SENTINEL);
    }

    default public LogAppendInfo appendAsLeader(MemoryRecords records, AppendOrigin origin, int leaderEpoch, VerificationGuard verificationGuard) throws KafkaStorageException {
        return this.appendAsLeader(records, leaderEpoch, origin, RequestLocal.noCaching(), verificationGuard);
    }

    default public LogAppendInfo appendAsLeader(MemoryRecords records, AppendOrigin origin, int leaderEpoch) throws KafkaStorageException {
        return this.appendAsLeader(records, leaderEpoch, origin, RequestLocal.noCaching(), VerificationGuard.SENTINEL);
    }

    default public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin) throws KafkaStorageException {
        return this.appendAsLeader(records, leaderEpoch, origin, RequestLocal.noCaching(), VerificationGuard.SENTINEL);
    }

    default public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch) throws KafkaStorageException {
        return this.appendAsLeader(records, leaderEpoch, AppendOrigin.CLIENT, RequestLocal.noCaching(), VerificationGuard.SENTINEL);
    }

    public LogAppendInfo appendAsFollower(MemoryRecords var1, int var2) throws KafkaStorageException;

    public LogAppendInfo appendAsMirrorLeader(MemoryRecords var1, int var2, Optional<Integer> var3) throws KafkaStorageException, UnexpectedAppendEpochException;

    @Override
    public Optional<Integer> latestEpoch();

    @Override
    public Optional<OffsetAndEpoch> endOffsetForEpoch(int var1);

    public void assignEpochStartOffset(int var1, long var2);

    @Override
    public long highWatermark();

    public long updateHighWatermark(long var1);

    public long updateHighWatermark(LogOffsetMetadata var1);

    public Optional<LogOffsetMetadata> maybeIncrementHighWatermark(LogOffsetMetadata var1);

    public Optional<Long> maybeUpdateHighWatermark(long var1);

    public LogOffsetSnapshot fetchOffsetSnapshot();

    public LogOffsetMetadata firstOffsetMetadata();

    public boolean maybeIncrementLogStartOffset(long var1, LogStartOffsetIncrementReason var3);

    public AbstractFetchDataInfo read(long var1, int var3, FetchIsolation var4, boolean var5, boolean var6) throws OffsetOutOfRangeException;

    public FetchDataInfo readLocal(long var1, int var3, FetchIsolation var4, boolean var5);

    public List<AbortedTxn> collectAbortedTransactions(long var1, long var3, boolean var5);

    public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> var1);

    public Map<Long, LastRecord> lastRecordsOfActiveProducers();

    public Map<Long, Integer> activeProducersWithLastSequence();

    public VerificationGuard maybeStartTransactionVerification(long var1, int var3, short var4, boolean var5);

    public VerificationGuard maybeCreateVerificationGuard(long var1, int var3, short var4, boolean var5);

    public VerificationGuard verificationGuard(long var1);

    public boolean hasOngoingTransaction(long var1, short var3);

    public List<LogSegment> splitOverflowedSegment(LogSegment var1);

    public void replaceSegments(List<LogSegment> var1, List<LogSegment> var2);

    public Optional<MaybeResolvedTimestampAndOffset> fetchOffsetByTimestamp(long var1);

    public List<Long> legacyFetchOffsetsBefore(long var1, int var3);

    public Optional<LogOffsetMetadata> convertToLocalOffsetMetadata(long var1);

    @Override
    default public boolean truncateMirrorTo(long targetOffset) {
        return this.truncateMirrorTo(targetOffset, false);
    }

    public void createDivergentLogForTesting(long var1);

    @Override
    public boolean truncateTo(long var1);

    public boolean truncateMirrorTo(long var1, boolean var3);

    public void truncateFullyAndStartAt(long var1, Optional<Long> var3);

    @Override
    default public void truncateFullyAndStartAt(long newOffset) {
        this.truncateFullyAndStartAt(newOffset, Optional.empty());
    }

    public int deleteOldSegments();

    public int deleteOldSegments(int var1);

    public boolean maybeForceRoll(boolean var1, boolean var2);

    public long onlyLocalLogSegmentsSize();

    public long size();

    public long sizeAsyncUpdated();

    public LogSizeDetails sizeDetails();

    public LogSizeDetails sizeDetailsAsyncUpdated();

    public void recoverLocalLogAfterUncleanLeaderElection(TierState var1);

    public LogOffsetMetadata logEndOffsetMetadata();

    @Override
    public long logEndOffset();

    public void flush(boolean var1);

    public void flushUpToOffsetExclusive(long var1);

    public void flush(long var1, boolean var3);

    public long lastFlushTime();

    public LogConfig updateConfig(LogConfig var1);

    public long baseOffsetOfFirstSegment();

    public void truncateAndRestoreTierState(long var1, TierState var3);

    public Future<TierLogSegment> materializeTierStateUntilOffset(long var1);

    public Future<TierLogSegment> materializeTierStateUntilObjectId(long var1, UUID var3, int var4);

    public Optional<TopicIdPartition> topicIdPartition();

    public void assignTopicId(Uuid var1, int var2);

    default public void assignTopicId(Uuid topicId) {
        this.assignTopicId(topicId, -1);
    }

    public TierPartitionState tierPartitionState();

    public void stopTierMaterialization();

    public double lastShrinkageRatio();

    public void updateLastShrinkageRatio(double var1);

    public void newMetrics();

    public void removeLogMetrics();

    public void delete();

    public Optional<Long> latestProducerSnapshotOffset();

    public Optional<Long> oldestProducerSnapshotOffset();

    public long latestProducerStateEndOffset();

    public Optional<ProducerStateEntry> producerStateManagerLastEntry(long var1);

    public void takeProducerSnapshot();

    public LogSegment addSegment(LogSegment var1);

    public LogSegment roll(Optional<Long> var1, long var2);

    default public LogSegment roll(Optional<Long> expectedNextOffset) {
        return this.roll(expectedNextOffset, 0L);
    }

    default public LogSegment roll() {
        return this.roll(Optional.empty(), 0L);
    }

    public void removeExpiredProducers(long var1);

    public void getLruProducers(PriorityQueue<ProducerStateManager.LruProducerInfo> var1, int var2, long var3);

    public int removeLruProducers(List<ProducerStateManager.LruProducerInfo> var1, long var2);

    public ProducerStateManager producerStateManager();

    public UploadableSegment createUploadableSegment(LogSegment var1);

    public void setLogOffsetsListener(LogOffsetsListener var1);

    public long firstNotDeletableOffset();

    public Optional<Long> firstOffsetLockedFromDeletion();

    public Optional<Long> lockOffsetFromDeletion();

    public void unlockOffsetFromDeletion(long var1);

    public ChecksumParams checksumParams();

    default public void setMirrorStoppedOffset(Optional<Long> offset) {
    }

    public ResolveRangesResult resolveRanges(FetchIsolation var1, long var2, int var4);
}

