/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.log;

import io.confluent.kafka.storage.log.AbstractLog;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.storage.internals.log.LogSegment;

public record UploadableSegment(AbstractLog log, LogSegment logSegment, long nextOffset, Optional<File> producerStateOpt, ByteBuffer leaderEpochState, Optional<ByteBuffer> abortedTxnIndexOpt, File logSegmentFile, File offsetIndex, File timeIndex, long uploadedSize) {
    public UploadableSegment(AbstractLog log, LogSegment logSegment, long nextOffset, Optional<File> producerStateOpt, ByteBuffer leaderEpochState, Optional<ByteBuffer> abortedTxnIndexOpt) throws IOException {
        this(log, logSegment, nextOffset, producerStateOpt, leaderEpochState, abortedTxnIndexOpt, logSegment.log().file(), logSegment.offsetIndex().file(), logSegment.timeIndex().file(), UploadableSegment.uploadedSize(logSegment, leaderEpochState, producerStateOpt, abortedTxnIndexOpt));
    }

    private static long uploadedSize(LogSegment logSegment, ByteBuffer leaderEpochState, Optional<File> producerStateOpt, Optional<ByteBuffer> abortedTxnIndexOpt) {
        long producerStateLength = producerStateOpt.map(File::length).orElse(0L);
        long abortedTxnLength = abortedTxnIndexOpt.map(bb -> bb.limit() - bb.position()).orElse(0L);
        return (long)(logSegment.size() + (leaderEpochState.limit() - leaderEpochState.position())) + producerStateLength + abortedTxnLength;
    }

    public List<File> allFiles() {
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(this.logSegmentFile, this.offsetIndex, this.timeIndex));
        this.producerStateOpt.ifPresent(files::add);
        return Collections.unmodifiableList(files);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadableSegment that = (UploadableSegment)o;
        return this.log.equals(that.log) && this.logSegment.equals(that.logSegment) && this.nextOffset == that.nextOffset && this.producerStateOpt.equals(that.producerStateOpt) && this.leaderEpochState.equals(that.leaderEpochState) && this.abortedTxnIndexOpt.equals(that.abortedTxnIndexOpt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.log, this.logSegment, this.nextOffset, this.producerStateOpt, this.leaderEpochState, this.abortedTxnIndexOpt);
    }
}

