/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TierTopicSnapshotEntry
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static TierTopicSnapshotEntry getRootAsTierTopicSnapshotEntry(ByteBuffer _bb) {
        return TierTopicSnapshotEntry.getRootAsTierTopicSnapshotEntry(_bb, new TierTopicSnapshotEntry());
    }

    public static TierTopicSnapshotEntry getRootAsTierTopicSnapshotEntry(ByteBuffer _bb, TierTopicSnapshotEntry obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public TierTopicSnapshotEntry __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte partition() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public OffsetAndEpoch offsetAndEpoch() {
        return this.offsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch offsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long timestamp() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public byte key(int j) {
        int o = this.__offset(10);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int keyLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector keyVector() {
        return this.keyVector(new ByteVector());
    }

    public ByteVector keyVector(ByteVector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer keyAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer keyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public byte value(int j) {
        int o = this.__offset(12);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int valueLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector valueVector() {
        return this.valueVector(new ByteVector());
    }

    public ByteVector valueVector(ByteVector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer valueAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer valueInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public static void startTierTopicSnapshotEntry(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addPartition(FlatBufferBuilder builder, byte partition) {
        builder.addByte(0, partition, 0);
    }

    public static void addOffsetAndEpoch(FlatBufferBuilder builder, int offsetAndEpochOffset) {
        builder.addStruct(1, offsetAndEpochOffset, 0);
    }

    public static void addTimestamp(FlatBufferBuilder builder, long timestamp) {
        builder.addLong(2, timestamp, 0L);
    }

    public static void addKey(FlatBufferBuilder builder, int keyOffset) {
        builder.addOffset(3, keyOffset, 0);
    }

    public static int createKeyVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createKeyVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startKeyVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addValue(FlatBufferBuilder builder, int valueOffset) {
        builder.addOffset(4, valueOffset, 0);
    }

    public static int createValueVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createValueVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startValueVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endTierTopicSnapshotEntry(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishTierTopicSnapshotEntryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedTierTopicSnapshotEntryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public TierTopicSnapshotEntry get(int j) {
            return this.get(new TierTopicSnapshotEntry(), j);
        }

        public TierTopicSnapshotEntry get(TierTopicSnapshotEntry obj, int j) {
            return obj.__assign(TierTopicSnapshotEntry.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

