/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.store.objects;

import io.confluent.kafka.storage.SegmentMetadataLayoutPutMode;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.Crc32cChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import io.confluent.kafka.storage.tier.store.CombinedObjectStream;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ThrottledSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TierSegmentUpload<P> {
    private static final Logger log = LoggerFactory.getLogger(TierSegmentUpload.class);
    private final Time time = Time.SYSTEM;
    private final SegmentMetadataLayoutPutMode putMode;
    private final ObjectMetadata objectMetadata;
    private final File segment;
    private final File offsetIdx;
    private final File timestampIdx;
    private final Optional<P> producerStateSnapshotOpt;
    private final Optional<ByteBuffer> txnIdxOpt;
    private final Optional<ByteBuffer> epochStateOpt;
    private final LinkedHashMap<FragmentType, Object> orderedFragmentsForCombinedObject = new LinkedHashMap();
    private final long length;
    private static final List<FragmentType> CANONICAL_ORDER_FOR_COMBINED_OBJECT;

    protected TierSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<P> producerStateSnapshotOpt, Optional<ByteBuffer> txnIdxOpt, Optional<ByteBuffer> epochStateOpt) {
        this.putMode = putMode;
        this.objectMetadata = objectMetadata;
        this.segment = segment;
        this.offsetIdx = offsetIdx;
        this.producerStateSnapshotOpt = producerStateSnapshotOpt;
        this.timestampIdx = timestampIdx;
        this.txnIdxOpt = txnIdxOpt;
        this.epochStateOpt = epochStateOpt;
        this.orderedFragmentsForCombinedObject.put(FragmentType.SEGMENT, segment);
        this.orderedFragmentsForCombinedObject.put(FragmentType.OFFSET_INDEX, offsetIdx);
        this.orderedFragmentsForCombinedObject.put(FragmentType.TIMESTAMP_INDEX, timestampIdx);
        producerStateSnapshotOpt.ifPresent(producerState -> this.orderedFragmentsForCombinedObject.put(FragmentType.PRODUCER_STATE, producerState));
        txnIdxOpt.ifPresent(txnIdx -> this.orderedFragmentsForCombinedObject.put(FragmentType.TRANSACTION_INDEX, txnIdx));
        epochStateOpt.ifPresent(epochState -> this.orderedFragmentsForCombinedObject.put(FragmentType.EPOCH_STATE, epochState));
        long totalLength = 0L;
        for (Object fragment : this.orderedFragmentsForCombinedObject.values()) {
            if (fragment == null) continue;
            if (fragment instanceof File) {
                totalLength += ((File)fragment).length();
                continue;
            }
            if (!(fragment instanceof ByteBuffer)) continue;
            ByteBuffer buf = (ByteBuffer)fragment;
            totalLength += (long)(buf.limit() - buf.position());
        }
        this.length = totalLength;
    }

    public ObjectMetadata objectMetadata() {
        return this.objectMetadata;
    }

    public File segment() {
        return this.segment;
    }

    public File offsetIdx() {
        return this.offsetIdx;
    }

    public File timestampIdx() {
        return this.timestampIdx;
    }

    public Optional<P> producerStateSnapshotOpt() {
        return this.producerStateSnapshotOpt;
    }

    public Optional<ByteBuffer> txnIdxOpt() {
        return this.txnIdxOpt;
    }

    public Optional<ByteBuffer> epochStateOpt() {
        return this.epochStateOpt;
    }

    public Optional<Throttler> throttlerOpt() {
        if (this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            return throttledSegmentUpload.throttlerOpt();
        }
        return Optional.empty();
    }

    public SegmentMetadataLayoutPutMode putMode() {
        return this.putMode;
    }

    public LinkedHashMap<FragmentType, Object> orderedFragmentsForCombinedObject() {
        return this.orderedFragmentsForCombinedObject;
    }

    public static List<FragmentType> canonicalOrderForCombinedObject() {
        return CANONICAL_ORDER_FOR_COMBINED_OBJECT;
    }

    public long length() {
        return this.length;
    }

    public CombinedObjectStream makeCombinedObjectStream() throws IOException {
        long start = this.time.milliseconds();
        CombinedObjectStream stream = new CombinedObjectStream(this);
        long elapsed = this.time.milliseconds() - start;
        log.info("[{}, baseOffset={}] constructed CombinedObjectStream in {}ms of total length {} bytes", new Object[]{this.objectMetadata.topicIdPartition(), this.objectMetadata.baseOffset(), elapsed, this.length});
        return stream;
    }

    public Optional<String> getChecksumForCombinedObject(E2EChecksumStore checksumStore) {
        if (!checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT_WITH_METADATA)) {
            return Optional.empty();
        }
        ChecksumStore store = checksumStore.store();
        if (!(store instanceof Crc32cChecksumStore)) {
            log.warn("Checksum requested on segment-with-metadata CombinedObject, but supplied checksum store does not use CRC32C. Skipping checksum.");
            return Optional.empty();
        }
        long start = this.time.milliseconds();
        Checksum crc32c = this.computeCrc32CFromStore((Crc32cChecksumStore)store);
        if (crc32c == null) {
            log.warn("Failed to compute CRC32C for segment-with-metadata CombinedObject from checksum store. Recomputing from scratch.");
            crc32c = this.recomputeCrc32C();
        }
        String checksum = E2EChecksumUtils.convertTo32BitBase64(crc32c.getValue());
        long elapsed = this.time.milliseconds() - start;
        if (this.objectMetadata != null) {
            log.info("[{}, baseOffset={}] computed checksum for CombinedObject in {}ms: {}", new Object[]{this.objectMetadata.topicIdPartition(), this.objectMetadata.baseOffset(), elapsed, checksum});
        }
        return Optional.of(checksum);
    }

    public Checksum computeCrc32CFromStore(Crc32cChecksumStore store) {
        Checksum runningChecksum = store.emptyChecksum();
        for (Map.Entry<FragmentType, Object> entrySet : this.orderedFragmentsForCombinedObject.entrySet()) {
            FragmentType fragmentType = entrySet.getKey();
            Object fragment = entrySet.getValue();
            if (fragment instanceof File) {
                File file = (File)fragment;
                Checksum crc1 = runningChecksum;
                Optional<Checksum> combinedChecksumOpt = store.get(file.getAbsolutePath()).map(ChecksumInfo::checksum).map(crc2 -> store.combine(crc1, (Checksum)crc2, file.length()));
                if (combinedChecksumOpt.isPresent()) {
                    runningChecksum = combinedChecksumOpt.get();
                    continue;
                }
                log.warn("Checksum entry not found for file {}. Recomputing from scratch.", (Object)file.getAbsolutePath());
                E2EChecksumUtils.updateChecksumWithFile(runningChecksum, file);
                continue;
            }
            if (fragment instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)fragment;
                Checksums.update((Checksum)runningChecksum, (ByteBuffer)bb, (int)bb.remaining());
                continue;
            }
            log.error("Unhandled Object type {} for FragmentType {} in ordered fragments list", fragment.getClass(), (Object)fragmentType);
        }
        return runningChecksum;
    }

    public Checksum recomputeCrc32C() {
        CRC32C crc32c = new CRC32C();
        for (Map.Entry<FragmentType, Object> entrySet : this.orderedFragmentsForCombinedObject.entrySet()) {
            FragmentType fragmentType = entrySet.getKey();
            Object fragment = entrySet.getValue();
            if (fragment instanceof File) {
                File file = (File)fragment;
                E2EChecksumUtils.updateChecksumWithFile(crc32c, file);
                continue;
            }
            if (fragment instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)fragment;
                Checksums.update((Checksum)crc32c, (ByteBuffer)bb, (int)bb.remaining());
                continue;
            }
            log.error("Unhandled Object type {} for FragmentType {} in ordered fragments list", fragment.getClass(), (Object)fragmentType);
        }
        return crc32c;
    }

    public List<File> validateFileChecksums(E2EChecksumStore checksumStore, Map<String, String> metadata) {
        ArrayList<File> invalidFiles = new ArrayList<File>();
        for (Object fragment : this.orderedFragmentsForCombinedObject.values()) {
            Optional<String> recalculatedCrc;
            File file;
            Optional<String> actualCrc;
            if (!(fragment instanceof File) || (actualCrc = E2EChecksumUtils.getBase64CrcFromStore(checksumStore, file = (File)fragment, metadata)).equals(recalculatedCrc = E2EChecksumUtils.compute32BitBase64Crc32c(file))) continue;
            log.warn("found invalid checksum for file {}; expected: {}, actual: {}", new Object[]{file.getAbsolutePath(), recalculatedCrc, actualCrc});
            invalidFiles.add(file);
        }
        return invalidFiles;
    }

    public void postPutSegmentCleanup(E2EChecksumStore checksumStore) {
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT)) {
            checksumStore.store().remove(this.segment.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.OFFSET_INDEX)) {
            checksumStore.store().remove(this.offsetIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX)) {
            checksumStore.store().remove(this.timestampIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.PRODUCER_STATE) && this.producerStateSnapshotOpt.isPresent() && this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            throttledSegmentUpload.producerStateSnapshotOpt().ifPresent(file -> checksumStore.store().remove(file.getAbsolutePath()));
        }
    }

    static {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        fragmentTypes.add(FragmentType.SEGMENT);
        fragmentTypes.add(FragmentType.OFFSET_INDEX);
        fragmentTypes.add(FragmentType.TIMESTAMP_INDEX);
        fragmentTypes.add(FragmentType.PRODUCER_STATE);
        fragmentTypes.add(FragmentType.TRANSACTION_INDEX);
        fragmentTypes.add(FragmentType.EPOCH_STATE);
        CANONICAL_ORDER_FOR_COMBINED_OBJECT = Collections.unmodifiableList(fragmentTypes);
    }
}

