/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsCpuMeter {
    private static final Logger log = LoggerFactory.getLogger(ThreadsCpuMeter.class);
    private long cumulativeThreadCpuTimeInNanoSecs = 0L;
    private long systemTimeInNanoSecs = 0L;
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private final Collection<Long> threads;

    public ThreadsCpuMeter(Collection<Long> threads) {
        this.threads = threads;
    }

    public double computeCpuUtilizationPercent() {
        if (!this.threadMxBean.isThreadCpuTimeSupported() || !this.threadMxBean.isThreadCpuTimeEnabled()) {
            return 0.0;
        }
        long lastCpuTime = this.cumulativeThreadCpuTimeInNanoSecs;
        long lastSystemTime = this.systemTimeInNanoSecs;
        this.cumulativeThreadCpuTimeInNanoSecs = this.threads.stream().mapToLong(threadId -> this.threadMxBean.getThreadCpuTime((long)threadId)).sum();
        this.systemTimeInNanoSecs = System.nanoTime();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        log.debug("Last-CPU = {} Current-Cpu = {}", (Object)lastCpuTime, (Object)this.cumulativeThreadCpuTimeInNanoSecs);
        if (lastCpuTime == 0L || lastSystemTime == 0L || this.systemTimeInNanoSecs == lastSystemTime) {
            return 0.0;
        }
        return (double)(this.cumulativeThreadCpuTimeInNanoSecs - lastCpuTime) / ((double)(this.systemTimeInNanoSecs - lastSystemTime) * (double)numProcessors);
    }

    public double runCpuUtilizationBenchmark() {
        int iterations = 1000000;
        long begin = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            this.computeCpuUtilizationPercent();
        }
        long end = System.nanoTime();
        double avgTime = (double)(end - begin) / (double)iterations;
        log.debug("computeCpuUtilizationPercent Benchmark time {}", (Object)avgTime);
        return avgTime;
    }
}

