/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.affinity.ShardAllocatorManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;

public class AffinityShardIdentifierProvider
implements ShardIdentifierProvider {
    private static final Log log = (Log)LogFactory.getLog(AffinityShardIdentifierProvider.class, Log.class);
    private static final String NUMBER_OF_SHARDS_PROP = "nbr_of_shards";
    private RpcManager rpcManager;
    private DistributionManager distributionManager;
    private KeyTransformationHandler keyTransformationHandler;
    private ComponentRegistry componentRegistry;
    private ShardAllocatorManager shardAllocatorManager;

    public void initialize(Properties properties, BuildContext buildContext) {
        ServiceManager serviceManager = buildContext.getServiceManager();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)serviceManager.requestService(ComponentRegistryService.class);
        this.componentRegistry = componentRegistryService.getComponentRegistry();
        CacheManagerService cacheManagerService = (CacheManagerService)serviceManager.requestService(CacheManagerService.class);
        EmbeddedCacheManager embeddedCacheManager = cacheManagerService.getEmbeddedCacheManager();
        this.rpcManager = (RpcManager)this.componentRegistry.getComponent(RpcManager.class);
        String cacheName = this.componentRegistry.getCacheName();
        ClusteringConfiguration clusteringConfiguration = embeddedCacheManager.getCacheConfiguration(cacheName).clustering();
        Integer numberOfShards = AffinityShardIdentifierProvider.getNumberOfShards(properties);
        this.shardAllocatorManager = (ShardAllocatorManager)this.componentRegistry.getComponent(ShardAllocatorManager.class);
        this.shardAllocatorManager.initialize(numberOfShards, clusteringConfiguration.hash().numSegments());
        if (log.isDebugEnabled()) {
            log.debugf("Initializing ShardIdProvider with %d shards", numberOfShards);
        }
    }

    private int getSegment(Object key) {
        DistributionManager distributionManager = this.getDistributionManager();
        if (distributionManager == null) {
            return 0;
        }
        return distributionManager.getCacheTopology().getSegment(key);
    }

    public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
        Object key = this.getKeyTransformationHandler().stringToKey(idAsString, null);
        int segment = this.getSegment(key);
        String shardId = this.shardAllocatorManager.getShardFromSegment(segment);
        if (log.isDebugEnabled()) {
            log.debugf("Shard Identifier for segment[%s] = %s mapped to shard %s", id, segment, shardId);
        }
        return shardId;
    }

    public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.shardAllocatorManager.getShards();
    }

    public Set<String> getShardIdentifiersForDeletion(Class<?> entity, Serializable id, String idInString) {
        Address address = this.rpcManager != null ? this.rpcManager.getAddress() : LocalModeAddress.INSTANCE;
        Set<String> shardsForModification = this.shardAllocatorManager.getShardsForModification(address);
        if (shardsForModification == null) {
            return Collections.emptySet();
        }
        if (log.isDebugEnabled()) {
            log.debugf("Shard for modification, [%d] %s", shardsForModification.size(), shardsForModification);
        }
        return shardsForModification;
    }

    public Set<String> getAllShardIdentifiers() {
        return this.shardAllocatorManager.getShards();
    }

    private KeyTransformationHandler getKeyTransformationHandler() {
        if (this.keyTransformationHandler == null) {
            this.keyTransformationHandler = ((QueryInterceptor)((Object)this.componentRegistry.getComponent(QueryInterceptor.class))).getKeyTransformationHandler();
        }
        return this.keyTransformationHandler;
    }

    private DistributionManager getDistributionManager() {
        if (this.distributionManager == null) {
            this.distributionManager = (DistributionManager)this.componentRegistry.getComponent(DistributionManager.class);
        }
        return this.distributionManager;
    }

    private static Integer getNumberOfShards(Properties properties) {
        String nShards = properties.getProperty(NUMBER_OF_SHARDS_PROP);
        return nShards != null ? Integer.valueOf(nShards) : null;
    }
}

