/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.logging;

import java.io.IOException;
import java.util.List;
import javax.transaction.Transaction;
import org.hibernate.search.backend.LuceneWork;
import org.infinispan.commons.CacheException;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.util.logging.Log {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not locate key class %s", id=14001)
    public void keyClassNotFound(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot instantiate Transformer class %s", id=14002)
    public void couldNotInstantiaterTransformerClass(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Registering Query interceptor for cache %s", id=14003)
    public void registeringQueryInterceptor(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Custom commands backend initialized backing index %s", id=14004)
    public void commandsBackendInitialized(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Sent list of LuceneWork %s to node %s", id=14005)
    public void workListRemotedTo(Object var1, Address var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Apply list of LuceneWork %s delegating to local indexing engine", id=14006)
    public void applyingChangeListLocally(List<LuceneWork> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Going to ship list of LuceneWork %s to a remote master indexer", id=14007)
    public void applyingChangeListRemotely(List<LuceneWork> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Index named '%1$s' is ignoring configuration option 'directory_provider' set '%2$s': overridden to use the Infinispan Directory", id=14008)
    public void ignoreDirectoryProviderProperty(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable", id=14009)
    public void typeIsUsingDefaultTransformer(Class<?> var1);

    @Message(value="An IOException happened where none where expected", id=14010)
    public CacheException unexpectedIOException(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Some indexing work was lost because of an InterruptedException", id=14011)
    public void interruptedWhileBufferingWork(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Waiting for index lock was successful: '%1$s'", id=14012)
    public void waitingForLockAcquired(boolean var1);

    @Message(value="Cache named '%1$s' is being shut down. No longer accepting remote commands.", id=14013)
    public CacheException cacheIsStoppingNoCommandAllowed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reindexed %1$d entities", id=14014)
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%1$d documents indexed in %2$d ms", id=14015)
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Purging instances of '%s' from the index", id=14016)
    public void purgingIndex(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushing index '%s'", id=14017)
    public void flushingIndex(String var1);

    @Message(value="Error executing MassIndexer", id=14018)
    public CacheException errorExecutingMassIndexer(@Cause Throwable var1);

    @Message(value="Cannot run Lucene queries on a cache '%s' that does not have indexing enabled", id=14019)
    public IllegalStateException cannotRunLuceneQueriesIfNotIndexed(String var1);

    @Message(value="Queries containing grouping and aggregation functions must use projections.", id=14021)
    public ParsingException groupingAndAggregationQueriesMustUseProjections();

    @Message(value="Cannot have aggregate functions in GROUP BY clause", id=14022)
    public IllegalStateException cannotHaveAggregationsInGroupByClause();

    @Message(value="Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported", id=14023)
    public ParsingException multivaluedPropertyCannotBeUsedInGroupBy(String var1);

    @Message(value="The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued", id=14024)
    public ParsingException multivaluedPropertyCannotBeUsedInOrderBy(String var1);

    @Message(value="The query must not use grouping or aggregation", id=14025)
    public IllegalStateException queryMustNotUseGroupingOrAggregation();

    @Message(value="The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause", id=14026)
    public ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(String var1);

    @Message(value="The property path '%s' cannot be projected because it is multi-valued", id=14027)
    public ParsingException multivaluedPropertyCannotBeProjected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Autodetected a new indexed entity type in cache %s: %s. Autodetection support will be removed in Infinispan 10.0.", id=14028)
    public void detectedUnknownIndexedEntity(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Found undeclared indexable types in cache %s : %s. No indexes were created for these types because autodetection is not enabled for this cache.", id=14029)
    public void detectedUnknownIndexedEntities(String var1, String var2);

    @Message(value="The type %s is not an indexed entity.", id=14030)
    public IllegalArgumentException getNoIndexedEntityException(String var1);

    @Message(value="Could not locate error handler class %s", id=14032)
    public IllegalArgumentException unsupportedErrorHandlerConfigurationValueType(Class<?> var1);

    @Message(value="Unable to resume suspended transaction %s", id=14033)
    public CacheException unableToResumeSuspendedTx(Transaction var1, @Cause Throwable var2);

    @Message(value="Unable to suspend transaction", id=14034)
    public CacheException unableToSuspendTx(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error occurred while applying changes to the index", id=14035)
    public void errorOccurredApplyingChanges(@Cause Throwable var1);

    @Message(value="Prefix, wildcard or regexp queries cannot be fuzzy: %s", id=14036)
    public ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(String var1);

    @Message(value="Invalid boolean literal '%s'", id=14037)
    public ParsingException getInvalidBooleanLiteralException(String var1);

    @Message(value="infinispan-query.jar module is in the classpath but has not been properly initialised!", id=14038)
    public CacheException queryModuleNotInitialised();
}

