/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.ecm.webapp.search.SearchActions;
import org.nuxeo.ecm.webapp.trashManagement.TrashManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="deleteActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class DeleteActionsBean
extends InputController
implements DeleteActions,
Serializable,
SelectDataModelListener,
ResultsProviderFarm {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DeleteActionsBean.class);
    public static final String DELETED_CHILDREN_BY_COREAPI = "CURRENT_DOC_DELETED_CHILDREN";
    public static final String BOARD_USER_DELETED = "USER_DELETED_DOCUMENTS";
    public static final String DELETE_OUTCOME = "after_delete";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient TrashManager trashManager;
    @In(create=true)
    protected transient LockActions lockActions;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true)
    protected transient SearchActions searchActions;
    @Out(required=false)
    @Deprecated
    protected PagedDocumentsProvider resultsProvider;
    protected DocumentModelList currentDocumentChildren;
    @In
    protected transient Principal currentUser;
    protected Boolean searchDeletedDocuments;
    protected transient TrashService trashService;
    protected static final int OP_DELETE = 1;
    protected static final int OP_PURGE = 2;
    protected static final int OP_UNDELETE = 3;

    protected TrashService getTrashService() {
        if (this.trashService == null) {
            try {
                this.trashService = (TrashService)Framework.getService(TrashService.class);
            }
            catch (Exception e) {
                throw new RuntimeException("TrashService not available", e);
            }
        }
        return this.trashService;
    }

    @Override
    public boolean getCanDeleteItem(DocumentModel container) throws ClientException {
        if (container == null) {
            return false;
        }
        return this.getTrashService().folderAllowsDelete(container);
    }

    @Override
    public boolean getCanDelete() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        try {
            return this.getTrashService().canDelete(docs, this.currentUser, false);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean getCanDeleteSections() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        try {
            return this.getTrashService().canDelete(docs, this.currentUser, true);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean getCanPurge() throws ClientException {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        try {
            return this.getTrashService().canPurgeOrUndelete(docs, this.currentUser);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docs) {
        try {
            return this.getTrashService().checkDeletePermOnParents(docs);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public String deleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelectionSections() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_SECTIONS")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelection(List<DocumentModel> docs) throws ClientException {
        int op = this.isTrashManagementEnabled() ? 1 : 2;
        return this.actOnSelection(op, docs);
    }

    @Override
    public String purgeSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.purgeSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String purgeSelection(List<DocumentModel> docs) throws ClientException {
        return this.actOnSelection(2, docs);
    }

    @Override
    public String undeleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.undeleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String undeleteSelection(List<DocumentModel> docs) throws ClientException {
        return this.actOnSelection(3, docs);
    }

    protected String actOnSelection(int op, List<DocumentModel> docs) throws ClientException {
        String msgid;
        Set parentRefs;
        TrashInfo info;
        if (docs == null) {
            return null;
        }
        try {
            info = this.getTrashService().getTrashInfo(docs, this.currentUser, false, false);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return null;
        }
        DocumentModel targetContext = this.getTrashService().getAboveDocument(this.navigationContext.getCurrentDocument(), info.rootPaths);
        this.documentsListsManager.removeFromAllLists(info.docs);
        switch (op) {
            case 2: {
                this.getTrashService().purgeDocuments(this.documentManager, info.rootRefs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 1: {
                this.getTrashService().trashDocuments(info.docs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 3: {
                parentRefs = this.getTrashService().undeleteDocuments(info.docs);
                msgid = "n_undeleted_docs";
                break;
            }
            default: {
                throw new AssertionError(op);
            }
        }
        this.navigationContext.setCurrentDocument(targetContext);
        for (DocumentRef parentRef : parentRefs) {
            DocumentModel parent = this.documentManager.getDocument(parentRef);
            if (parent == null) continue;
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
        }
        if (info.proxies > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, "can_not_delete_proxies", new Object[0]);
        }
        Object[] params = new Object[]{info.docs.size()};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + (String)this.resourcesAccessor.getMessages().get(msgid), params);
        return this.computeOutcome(DELETE_OUTCOME);
    }

    @Override
    public boolean isTrashManagementEnabled() {
        return this.trashManager.isTrashManagementEnabled();
    }

    @Override
    public SelectDataModel getDeletedChildrenSelectModel() throws ClientException {
        DocumentModelList documents = this.getCurrentDocumentDeletedChildrenPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        SelectDataModelImpl model = new SelectDataModelImpl("CHILDREN_DOCUMENT_LIST", (List)documents, selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    @Override
    public DocumentModelList getCurrentDocumentDeletedChildrenPage() throws ClientException {
        if (this.documentManager == null) {
            log.error((Object)"documentManager not initialized");
            return new DocumentModelListImpl();
        }
        try {
            ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
            this.resultsProvider = resultsProvidersCache.get(DELETED_CHILDREN_BY_COREAPI);
            this.currentDocumentChildren = this.resultsProvider.getCurrentPage();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
        return this.currentDocumentChildren;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION_TRASH", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION_TRASH", data);
        }
    }

    public List<Action> getActionsForTrashSelection() {
        return this.webActions.getUnfiltredActionsList("CURRENT_SELECTION_TRASH_LIST");
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        PagedDocumentsProvider provider = null;
        if (BOARD_USER_DELETED.equals(name)) {
            Object[] params = new Object[]{this.currentUser.getName()};
            try {
                provider = this.getQmDocuments(name, params, sortInfo);
            }
            catch (Exception e) {
                log.error((Object)"sorted query failed");
                log.debug((Object)e);
                log.error((Object)"retrying without sort parameters");
                provider = this.getQmDocuments(name, params, null);
            }
        } else if (DELETED_CHILDREN_BY_COREAPI.equals(name)) {
            provider = this.getResultsProviderForDeletedDocs(name, sortInfo);
        }
        provider.setName(name);
        return provider;
    }

    protected PagedDocumentsProvider getResultsProviderForDeletedDocs(String name, SortInfo sortInfo) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (DELETED_CHILDREN_BY_COREAPI.equals(name)) {
            PagedDocumentsProvider provider = this.getChildrenResultsProviderQMPattern(name, currentDoc, sortInfo);
            provider.setName(name);
            return provider;
        }
        throw new ClientException("Unknown provider: " + name);
    }

    protected PagedDocumentsProvider getQmDocuments(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        return this.queryModelActions.get(qmName).getResultsProvider(this.documentManager, params, sortInfo);
    }

    protected PagedDocumentsProvider getChildrenResultsProviderQMPattern(String queryModelName, DocumentModel parent, SortInfo sortInfo) throws ClientException {
        String parentId = parent.getId();
        Object[] params = new Object[]{parentId};
        return this.getResultsProvider(queryModelName, params, sortInfo);
    }

    protected PagedDocumentsProvider getResultsProvider(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        QueryModel qm = this.queryModelActions.get(qmName);
        return qm.getResultsProvider(this.documentManager, params, sortInfo);
    }

    @Override
    public Boolean getSearchDeletedDocuments() {
        return this.searchDeletedDocuments;
    }

    @Override
    public void setSearchDeletedDocuments(Boolean searchDeletedDocuments) throws ClientException {
        this.searchDeletedDocuments = searchDeletedDocuments;
        String[] states = null;
        states = searchDeletedDocuments != false ? new String[]{"project", "approved", "obsolete", "deleted"} : new String[]{"project", "approved", "obsolete"};
        this.searchActions.getDocumentModel().setProperty("advanced_search", "currentLifeCycleStates", (Object)states);
    }

    @Override
    public void restoreCurrentDocument() throws ClientException {
        ArrayList<DocumentModel> doc = new ArrayList<DocumentModel>();
        doc.add(this.navigationContext.getCurrentDocument());
        this.undeleteSelection(doc);
    }

    @Override
    public boolean getCanRestoreCurrentDoc() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            log.warn((Object)"Null currentDocument in navigationContext");
            return false;
        }
        try {
            return this.getTrashService().canPurgeOrUndelete(Collections.singletonList(doc), this.currentUser);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Observer(value={"folderishDocumentSelectionChanged"})
    @BypassInterceptors
    public void resetProviderCache() {
        ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
        resultsProvidersCache.invalidate(DELETED_CHILDREN_BY_COREAPI);
    }

    public boolean restoreActionDisplay() throws ClientException {
        return this.getCanRestoreCurrentDoc() && this.isTrashManagementEnabled();
    }
}

