/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.shield;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.faces.Redirect;

@Name(value="errorPageActionListener")
@Scope(value=ScopeType.SESSION)
@Startup
public class ErrorPageActionListener
implements Serializable {
    private static final long serialVersionUID = -1467366100627478101L;
    @In(required=false)
    protected Throwable applicationException;

    public String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        if (this.applicationException != null) {
            Throwable cause = this.applicationException.getCause();
            if (cause instanceof SecurityException) {
                sb.append(ErrorPageActionListener.getStackTrace(cause));
                cause = cause.getCause();
            } else {
                sb.append(ErrorPageActionListener.getStackTrace(this.applicationException));
            }
            if (cause != null) {
                do {
                    sb.append(ErrorPageActionListener.getStackTrace(cause));
                } while (null != (cause = cause.getCause()));
            }
        }
        return sb.toString();
    }

    protected static String getStackTrace(Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (null != t) {
            sb.append("\n\n");
            sb.append(t.getClass().getName());
            sb.append("\n\n");
            sb.append(t.getLocalizedMessage());
            sb.append("\n\n");
            for (StackTraceElement element : t.getStackTrace()) {
                sb.append(element.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static void toLoginPage() {
        Seam.invalidateSession();
        Redirect.instance().setViewId("/login.jsp");
        Redirect.instance().execute();
    }
}

