/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryServiceListener;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryService {
    private static final Map<String, DirectoryService> instances = new HashMap<String, DirectoryService>();

    public static DirectoryService getInstance() {
        return DirectoryService.getInstance("default");
    }

    public static synchronized DirectoryService getInstance(String instanceId) {
        DirectoryService service = instances.get(instanceId = instanceId.trim());
        if (service == null) {
            service = new DefaultDirectoryService(instanceId);
            instances.put(instanceId, service);
        }
        return service;
    }

    public static synchronized Set<DirectoryService> getAllInstances() {
        return new HashSet<DirectoryService>(instances.values());
    }

    public abstract void startup(DirectoryServiceListener var1, Hashtable<String, Object> var2) throws NamingException;

    public abstract void shutdown() throws NamingException;

    public abstract void sync() throws NamingException;

    public abstract boolean isStarted();

    public abstract DirectoryServiceConfiguration getConfiguration();

    public abstract Context getJndiContext(String var1) throws NamingException;

    public abstract Context getJndiContext(LdapDN var1, String var2, byte[] var3, String var4, String var5) throws NamingException;
}

