/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.AbstractOutputSolver;

public class DimacsStringSolver
extends AbstractOutputSolver {
    private static final long serialVersionUID = 1L;
    private StringBuffer out;
    private int firstCharPos;
    private final int initBuilderSize;
    private int maxvarid = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.DimacsStringSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DimacsStringSolver() {
        this(16);
    }

    public DimacsStringSolver(int initSize) {
        this.out = new StringBuffer(initSize);
        this.initBuilderSize = initSize;
    }

    public StringBuffer getOut() {
        return this.out;
    }

    public int newVar() {
        return 0;
    }

    public int newVar(int howmany) {
        this.setNbVars(howmany);
        return howmany;
    }

    protected void setNbVars(int howmany) {
        this.nbvars = howmany;
        this.maxvarid = howmany;
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.out.append(" ");
        this.out.append(nb);
        this.nbclauses = nb;
        this.fixedNbClauses = true;
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.firstCharPos = 7 + Integer.toString(this.nbvars).length();
                this.out.append("                    ");
                this.out.append("\n");
                this.nbclauses = 0;
            }
            this.firstConstr = false;
        }
        if (!this.fixedNbClauses) {
            ++this.nbclauses;
        }
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            this.out.append(iterator.next()).append(" ");
        }
        this.out.append("0\n");
        return null;
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        if (!$assertionsDisabled && degree != 1) {
            throw new AssertionError();
        }
        if (this.firstConstr) {
            this.firstCharPos = 0;
            this.out.append("                    ");
            this.out.append("\n");
            this.nbclauses = 0;
            this.firstConstr = false;
        }
        int i = 0;
        while (i <= literals.size()) {
            int j = i + 1;
            while (j < literals.size()) {
                if (!this.fixedNbClauses) {
                    ++this.nbclauses;
                }
                this.out.append(-literals.get(i));
                this.out.append(" ");
                this.out.append(-literals.get(j));
                this.out.append(" 0\n");
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        if (n > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + n);
        }
        if (!$assertionsDisabled && n != 1) {
            throw new AssertionError();
        }
        this.addAtMost(literals, n);
        this.addAtLeast(literals, n);
        return null;
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        if (!$assertionsDisabled && degree != 1) {
            throw new AssertionError();
        }
        return this.addClause(literals);
    }

    public void reset() {
        this.fixedNbClauses = false;
        this.firstConstr = true;
        this.out = new StringBuffer(this.initBuilderSize);
        this.maxvarid = 0;
    }

    public String toString(String prefix) {
        return "Dimacs output solver";
    }

    public int nConstraints() {
        return this.nbclauses;
    }

    public int nVars() {
        return this.maxvarid;
    }

    public String toString() {
        this.out.insert(this.firstCharPos, "p cnf " + this.maxvarid + " " + this.nbclauses);
        return this.out.toString();
    }

    public int nextFreeVarId(boolean reserve) {
        if (reserve) {
            return ++this.maxvarid;
        }
        return this.maxvarid + 1;
    }

    public int[] modelWithInternalVariables() {
        throw new UnsupportedOperationException();
    }

    public int realNumberOfVariables() {
        return this.maxvarid;
    }

    public void registerLiteral(int p) {
        throw new UnsupportedOperationException();
    }
}

