/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.ConvertColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertColorProfileJ2DOp
extends OperationImplementation<ConvertColorProfileOp, BufferedImage> {
    private static final String CLASS = ConvertColorProfileJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected BufferedImage execute(ConvertColorProfileOp operation, BufferedImage bufferedImage) {
        ICC_Profile colorProfile = operation.getICCProfile();
        logger.fine("convertColorProfile(" + ImageUtils.getICCProfileName((ICC_Profile)colorProfile) + ")");
        Java2DUtils.logImage((Logger)logger, (String)">>>> source bufferedImage", (RenderedImage)bufferedImage);
        ICC_Profile sourceProfile = ImageUtils.getICCProfile((RenderedImage)bufferedImage);
        String sourceProfileName = ImageUtils.getICCProfileName((ICC_Profile)sourceProfile);
        logger.finer(">>>> Converting profile from " + sourceProfileName + " to " + ImageUtils.getICCProfileName((ICC_Profile)colorProfile));
        RenderingHints hints = null;
        ColorConvertOp ccOp = new ColorConvertOp(new ICC_Profile[]{colorProfile}, hints);
        logger.warning(">>>> **** WARNING: convertColorProfile() is reducing depth to 8 bit!");
        WritableRaster raster = Raster.createPackedRaster(3, bufferedImage.getWidth(), bufferedImage.getHeight(), 3, 8, null);
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(colorProfile);
        DirectColorModel colorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
        BufferedImage image2 = new BufferedImage(colorModel, raster, false, Java2DUtils.getProperties((BufferedImage)bufferedImage));
        bufferedImage = ccOp.filter(bufferedImage, image2);
        Java2DUtils.logImage((Logger)logger, (String)">>>> >>>> convertColorProfile() returning ", (RenderedImage)bufferedImage);
        return bufferedImage;
    }
}

