/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.NodeView;
import org.nuxeo.ecm.platform.routing.core.impl.TransitionView;

@Operation(id="Document.Routing.GetGraph", category="Routing", label="Get graph", description="get graph nodes.")
public class GetGraphOperation {
    public static final String ID = "Document.Routing.GetGraph";
    @Context
    protected OperationContext context;
    @Param(name="routeDocId", required=true)
    protected String routeDocId;
    @Context
    protected CoreSession session;

    @OperationMethod
    public Blob run() throws Exception {
        GetRouteAsJsonUnrestricted unrestrictedRunner = new GetRouteAsJsonUnrestricted(this.session, this.routeDocId);
        String json = unrestrictedRunner.getJSON();
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), "application/json");
    }

    public static String toJSON(GraphRoute route) {
        try {
            HashMap<String, Collection<Object>> graph = new HashMap<String, Collection<Object>>();
            ArrayList<NodeView> nodeViews = new ArrayList<NodeView>();
            HashMap<String, TransitionView> tranViews = new HashMap<String, TransitionView>();
            for (GraphNode node : route.getNodes()) {
                nodeViews.add(new NodeView(node));
                List<GraphNode.Transition> transitions = node.getOutputTransitions();
                for (GraphNode.Transition transition : transitions) {
                    GraphNode targetNode = route.getNode(transition.getTarget());
                    tranViews.put(transition.getId(), new TransitionView(node.getId(), targetNode.getId(), transition.getLabel()));
                }
            }
            graph.put("nodes", nodeViews);
            graph.put("transitions", tranViews.values());
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, graph);
            return writer.toString();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    class GetRouteAsJsonUnrestricted
    extends UnrestrictedSessionRunner {
        String docId;
        String json;

        protected GetRouteAsJsonUnrestricted(CoreSession session, String docId) {
            super(session);
            this.docId = docId;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            GraphRoute route = (GraphRoute)doc.getAdapter(GraphRoute.class);
            this.json = GetGraphOperation.toJSON(route);
        }

        public String getJSON() throws ClientException {
            this.runUnrestricted();
            return this.json;
        }
    }
}

