/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.core.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dam.core.service.InheritedPropertiesDescriptor;
import org.nuxeo.dam.core.service.InheritedPropertiesService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class InheritedPropertiesServiceImpl
extends DefaultComponent
implements InheritedPropertiesService {
    public static final String INHERITED_PROPERTIES_EP = "inheritedProperties";
    private static final Log log = LogFactory.getLog(InheritedPropertiesServiceImpl.class);
    protected Map<String, InheritedPropertiesDescriptor> inheritedPropertiesDescriptors;

    public void activate(ComponentContext context) throws Exception {
        this.inheritedPropertiesDescriptors = new HashMap<String, InheritedPropertiesDescriptor>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (INHERITED_PROPERTIES_EP.equals(extensionPoint)) {
            InheritedPropertiesDescriptor descriptor = (InheritedPropertiesDescriptor)contribution;
            if (this.inheritedPropertiesDescriptors.containsKey(descriptor.getSchema())) {
                log.info((Object)("Already  registered schema: " + descriptor.getSchema() + ", overriding it."));
            }
            this.inheritedPropertiesDescriptors.put(descriptor.getSchema(), descriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (INHERITED_PROPERTIES_EP.equals(extensionPoint)) {
            InheritedPropertiesDescriptor descriptor = (InheritedPropertiesDescriptor)contribution;
            this.inheritedPropertiesDescriptors.remove(descriptor.getSchema());
        }
    }

    @Override
    public Map<String, InheritedPropertiesDescriptor> getInheritedPropertiesDescriptors() {
        return Collections.unmodifiableMap(this.inheritedPropertiesDescriptors);
    }

    @Override
    public void inheritProperties(DocumentModel from, DocumentModel to) throws ClientException {
        for (InheritedPropertiesDescriptor descriptor : this.inheritedPropertiesDescriptors.values()) {
            this.inheritProperties(descriptor, from, to);
        }
    }

    protected void inheritProperties(InheritedPropertiesDescriptor descriptor, DocumentModel from, DocumentModel to) throws ClientException {
        String schema = descriptor.getSchema();
        if (from.hasSchema(schema) && to.hasSchema(schema)) {
            Map fromDataModel = from.getDataModel(schema).getMap();
            if (descriptor.allProperties()) {
                to.getDataModel(schema).setMap(fromDataModel);
            } else {
                this.inheritDefinedProperties(descriptor, fromDataModel, to);
            }
        }
    }

    protected void inheritDefinedProperties(InheritedPropertiesDescriptor descriptor, Map<String, Object> fromDataModel, DocumentModel to) throws ClientException {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String property : descriptor.getProperties()) {
            Object value = fromDataModel.get(property);
            if (value == null) continue;
            newMap.put(property, value);
        }
        to.getDataModel(descriptor.getSchema()).setMap(newMap);
    }
}

