/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import java.util.Collections;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class NuxeoConnectionManagerFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(NuxeoConnectionManagerFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name objName, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)obj;
        if (!ConnectionManager.class.getName().equals(ref.getClassName())) {
            return null;
        }
        int size = objName.size();
        String repositoryName = size == 1 ? "default" : objName.get(size - 1);
        if (NuxeoContainer.getConnectionManager(repositoryName) == null) {
            NuxeoConnectionManagerConfiguration config = new NuxeoConnectionManagerConfiguration();
            for (RefAddr addr : Collections.list(ref.getAll())) {
                String name = addr.getType();
                String value = (String)addr.getContent();
                try {
                    BeanUtils.setProperty((Object)config, (String)name, (Object)value);
                }
                catch (Exception e) {
                    log.error((Object)String.format("NuxeoConnectionManagerFactory cannot set %s = %s", name, value));
                }
            }
            NuxeoContainer.initConnectionManager(repositoryName, config);
        }
        return NuxeoContainer.getConnectionManager(repositoryName);
    }
}

