/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.task;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.api.PublishingException;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreProxyFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.publisher.task.ChangePermissionUnrestricted;
import org.nuxeo.ecm.platform.publisher.task.DeleteDocumentUnrestricted;
import org.nuxeo.ecm.platform.publisher.task.LookupState;
import org.nuxeo.ecm.platform.publisher.task.LookupStateByACL;
import org.nuxeo.ecm.platform.publisher.task.LookupStateByTask;
import org.nuxeo.ecm.platform.publisher.task.RemoveACLUnrestricted;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class CoreProxyWithWorkflowFactory
extends CoreProxyFactory
implements PublishedDocumentFactory {
    public static final String TASK_NAME = "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory";
    public static final String ACL_NAME = "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory";
    public static final String JBPM_ACL_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String PUBLISH_TASK_TYPE = "publish_moderate";
    public static final String LOOKUP_STATE_PARAM_KEY = "lookupState";
    public static final String LOOKUP_STATE_PARAM_BYACL = "byACL";
    public static final String LOOKUP_STATE_PARAM_BYTASK = "byTask";
    protected LookupState lookupState = new LookupStateByACL();

    public void init(CoreSession coreSession, ValidatorsRule validatorsRule, Map<String, String> parameters) throws ClientException {
        super.init(coreSession, validatorsRule, parameters);
        String lookupState = parameters.get(LOOKUP_STATE_PARAM_KEY);
        if (lookupState != null) {
            if (LOOKUP_STATE_PARAM_BYACL.equals(lookupState)) {
                this.setLookupByACL();
            } else if (LOOKUP_STATE_PARAM_BYTASK.equals(lookupState)) {
                this.setLookupByTask();
            }
        }
    }

    public void setLookupByTask() {
        this.lookupState = new LookupStateByTask();
    }

    public void setLookupByACL() {
        this.lookupState = new LookupStateByACL();
    }

    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        DocumentModel targetDocModel;
        if (targetNode instanceof CoreFolderPublicationNode) {
            CoreFolderPublicationNode coreNode = (CoreFolderPublicationNode)targetNode;
            targetDocModel = coreNode.getTargetDocumentModel();
        } else {
            targetDocModel = this.coreSession.getDocument((DocumentRef)new PathRef(targetNode.getPath()));
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        DocumentPublisherUnrestricted runner = new DocumentPublisherUnrestricted(this.coreSession, doc.getRef(), targetDocModel.getRef(), principal, null);
        runner.runUnrestricted();
        return runner.getPublishedDocument();
    }

    protected boolean isPublishedDocWaitingForPublication(DocumentModel doc, CoreSession session) throws ClientException {
        return !this.lookupState.isPublished(doc, session);
    }

    protected boolean isValidator(DocumentModel document, NuxeoPrincipal principal) throws PublishingException {
        try {
            String[] validators;
            for (String s : validators = this.getValidatorsFor(document)) {
                if (!principal.getName().equals(s) && !principal.isMemberOf(s)) continue;
                return true;
            }
        }
        catch (PublishingValidatorException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    protected void restrictPermission(DocumentModel newProxy, NuxeoPrincipal principal, CoreSession coreSession, ACL acl) throws PublishingValidatorException, PublishingException {
        ChangePermissionUnrestricted permissionChanger = new ChangePermissionUnrestricted(coreSession, newProxy, this.getValidatorsFor(newProxy), principal, "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory", acl);
        try {
            permissionChanger.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void createTask(DocumentModel document, CoreSession session, NuxeoPrincipal principal) throws PublishingValidatorException, ClientException, PublishingException {
        String[] actorIds = this.getValidatorsFor(document);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(Task.TaskVariableName.needi18n.name(), "true");
        variables.put(Task.TaskVariableName.taskType.name(), PUBLISH_TASK_TYPE);
        variables.put(TaskService.VariableName.documentId.name(), document.getId());
        variables.put(TaskService.VariableName.documentRepositoryName.name(), document.getRepositoryName());
        variables.put(TaskService.VariableName.initiator.name(), principal.getName());
        this.getTaskService().createTask(session, principal, document, "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory", Arrays.asList(actorIds), false, "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory", null, null, variables, null);
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, document);
        ctx.setProperty("recipients", (Serializable)actorIds);
        try {
            this.getEventProducer().fireEvent(ctx.newEvent("workflowTaskStart"));
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected TaskService getTaskService() {
        return (TaskService)Framework.getLocalService(TaskService.class);
    }

    protected void removeExistingProxiesOnPreviousVersions(DocumentModel newProxy) throws PublishingException {
        try {
            DocumentModel sourceVersion = this.coreSession.getSourceDocument(newProxy.getRef());
            DocumentModel dm = this.coreSession.getSourceDocument(sourceVersion.getRef());
            DocumentModelList brothers = this.coreSession.getProxies(dm.getRef(), newProxy.getParentRef());
            if (brothers != null && brothers.size() > 1) {
                for (DocumentModel doc : brothers) {
                    if (doc.getId().equals(newProxy.getId())) continue;
                    this.coreSession.removeDocument(doc.getRef());
                }
            }
        }
        catch (ClientException e1) {
            throw new PublishingException(e1.getMessage(), (Throwable)e1);
        }
    }

    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        this.removeExistingProxiesOnPreviousVersions(proxy);
        try {
            this.removeACL(proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationApproved);
            this.notifyEvent(PublishingEvent.documentPublicationApproved, proxy, this.coreSession);
            this.notifyEvent(PublishingEvent.documentPublished, proxy, this.coreSession);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
        ((SimpleCorePublishedDocument)publishedDocument).setPending(false);
    }

    protected void removeACL(DocumentModel document, CoreSession coreSession) throws PublishingException {
        try {
            RemoveACLUnrestricted remover = new RemoveACLUnrestricted(coreSession, document, "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory", JBPM_ACL_NAME);
            remover.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void endTask(DocumentModel document, NuxeoPrincipal currentUser, CoreSession session, String comment, PublishingEvent event) throws PublishingException {
        try {
            List tis = this.getTaskService().getTaskInstances(document, currentUser, session);
            String initiator = null;
            for (Task task : tis) {
                if (!task.getName().equals("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory")) continue;
                initiator = task.getVariable(TaskService.VariableName.initiator.name());
                task.end(session);
                session.saveDocument(task.getDocument());
                break;
            }
            DocumentModel liveDoc = this.getLiveDocument(session, document);
            HashMap<String, String[]> properties = new HashMap<String, String[]>();
            if (initiator != null) {
                properties.put("recipients", new String[]{initiator});
            }
            this.notifyEvent(event.name(), properties, comment, null, liveDoc, session);
        }
        catch (ClientException ce) {
            throw new PublishingException((Throwable)ce);
        }
    }

    protected DocumentModel getLiveDocument(CoreSession session, DocumentModel proxy) throws ClientException {
        GetsProxySourceDocumentsUnrestricted runner = new GetsProxySourceDocumentsUnrestricted(session, proxy);
        runner.runUnrestricted();
        return runner.liveDocument;
    }

    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        try {
            this.notifyEvent(PublishingEvent.documentPublicationRejected, proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationRejected);
            this.removeProxy(proxy, this.coreSession);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void removeProxy(DocumentModel doc, CoreSession coreSession) throws PublishingException {
        try {
            DeleteDocumentUnrestricted deleter = new DeleteDocumentUnrestricted(coreSession, doc);
            deleter.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    public PublishedDocument wrapDocumentModel(DocumentModel doc) throws ClientException {
        final SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.wrapDocumentModel(doc);
        new UnrestrictedSessionRunner(this.coreSession){

            public void run() throws ClientException {
                if (!CoreProxyWithWorkflowFactory.this.isPublished((PublishedDocument)publishedDocument, this.session)) {
                    publishedDocument.setPending(true);
                }
            }
        }.runUnrestricted();
        return publishedDocument;
    }

    protected boolean isPublished(PublishedDocument publishedDocument, CoreSession session) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        try {
            return this.lookupState.isPublished(proxy, session);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    public boolean canManagePublishing(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return proxy.isProxy() && this.hasValidationTask(proxy, currentUser);
    }

    protected boolean hasValidationTask(DocumentModel proxy, NuxeoPrincipal currentUser) throws ClientException {
        assert (currentUser != null);
        try {
            List tasks = this.getTaskService().getTaskInstances(proxy, currentUser, this.coreSession);
            for (Task task : tasks) {
                if (!task.getName().equals("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory")) continue;
                return true;
            }
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    public boolean hasValidationTask(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return this.hasValidationTask(proxy, currentUser);
    }

    protected class DocumentPublisherUnrestricted
    extends UnrestrictedSessionRunner {
        protected PublishedDocument result;
        protected DocumentRef docRef;
        protected DocumentRef targetRef;
        protected NuxeoPrincipal principal;
        protected String comment;

        public DocumentPublisherUnrestricted(CoreSession session, DocumentRef docRef, DocumentRef targetRef, NuxeoPrincipal principal, String comment) {
            super(session);
            this.comment = "";
            this.docRef = docRef;
            this.targetRef = targetRef;
            this.principal = principal;
            this.comment = comment;
        }

        public PublishedDocument getPublishedDocument() {
            return this.result;
        }

        public void run() throws ClientException {
            DocumentModelList list = this.session.getProxies(this.docRef, this.targetRef);
            DocumentModel proxy = null;
            if (list.isEmpty()) {
                proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                this.session.save();
                if (!CoreProxyWithWorkflowFactory.this.isValidator(proxy, this.principal)) {
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentWaitingPublication, CoreProxyWithWorkflowFactory.this.coreSession.getDocument(proxy.getRef()), CoreProxyWithWorkflowFactory.this.coreSession);
                    CoreProxyWithWorkflowFactory.this.restrictPermission(proxy, this.principal, this.session, null);
                    CoreProxyWithWorkflowFactory.this.createTask(proxy, CoreProxyWithWorkflowFactory.this.coreSession, this.principal);
                    publishedDocument.setPending(true);
                } else {
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                }
                this.result = publishedDocument;
            } else if (list.size() == 1) {
                if (CoreProxyWithWorkflowFactory.this.isPublishedDocWaitingForPublication((DocumentModel)list.get(0), this.session)) {
                    proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    if (!CoreProxyWithWorkflowFactory.this.isValidator(proxy, this.principal)) {
                        ACL acl = ((DocumentModel)list.get(0)).getACP().getACL("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory");
                        acl.add(0, (Object)new ACE(this.principal.getName(), "Read", true));
                        ACP acp = proxy.getACP();
                        acp.addACL(acl);
                        this.session.setACP(proxy.getRef(), acp, true);
                        this.session.save();
                        SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                        publishedDocument.setPending(true);
                        this.result = publishedDocument;
                    } else {
                        CoreProxyWithWorkflowFactory.this.endTask(proxy, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, "", PublishingEvent.documentPublicationApproved);
                        CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                        ACP acp = proxy.getACP();
                        acp.removeACL("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory");
                        this.session.setACP(proxy.getRef(), acp, true);
                        this.session.save();
                        this.result = new SimpleCorePublishedDocument(proxy);
                    }
                } else if (!CoreProxyWithWorkflowFactory.this.isValidator((DocumentModel)list.get(0), this.principal)) {
                    proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef), false);
                    this.session.save();
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentWaitingPublication, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    CoreProxyWithWorkflowFactory.this.restrictPermission(proxy, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, null);
                    this.session.save();
                    CoreProxyWithWorkflowFactory.this.createTask(proxy, CoreProxyWithWorkflowFactory.this.coreSession, this.principal);
                    publishedDocument.setPending(true);
                    this.result = publishedDocument;
                } else {
                    proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    this.session.save();
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    this.result = publishedDocument;
                }
            } else if (list.size() == 2) {
                DocumentModel waitingForPublicationDoc = null;
                this.session.save();
                for (DocumentModel dm : list) {
                    if (this.session.getACP(dm.getRef()).getACL("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory") == null) continue;
                    waitingForPublicationDoc = dm;
                }
                if (!CoreProxyWithWorkflowFactory.this.isValidator(waitingForPublicationDoc, this.principal)) {
                    ACL acl = waitingForPublicationDoc.getACP().getACL("org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory");
                    acl.add(0, (Object)new ACE(this.principal.getName(), "Read", true));
                    ACP acp = this.session.getACP(waitingForPublicationDoc.getRef());
                    acp.addACL(acl);
                    this.session.setACP(waitingForPublicationDoc.getRef(), acp, true);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(waitingForPublicationDoc);
                    publishedDocument.setPending(true);
                    this.result = publishedDocument;
                } else {
                    CoreProxyWithWorkflowFactory.this.endTask(waitingForPublicationDoc, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, this.comment, PublishingEvent.documentPublicationApproved);
                    this.session.removeDocument(waitingForPublicationDoc.getRef());
                    proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    this.result = publishedDocument;
                }
            }
            if (proxy != null) {
                proxy.detach(true);
            }
        }
    }

    private class GetsProxySourceDocumentsUnrestricted
    extends UnrestrictedSessionRunner {
        public DocumentModel liveDocument;
        private DocumentModel sourceDocument;
        private final DocumentModel document;

        public GetsProxySourceDocumentsUnrestricted(CoreSession session, DocumentModel proxy) {
            super(session);
            this.document = proxy;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument((DocumentRef)new IdRef(this.document.getSourceId()));
            this.liveDocument = this.session.getDocument((DocumentRef)new IdRef(this.sourceDocument.getSourceId()));
        }
    }
}

