/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RowMapper;

public class Model {
    private static final Log log = LogFactory.getLog(Model.class);
    private static final boolean DEBUG_UUIDS = false;
    public static final String ROOT_TYPE = "Root";
    public static final String REPOINFO_TABLE_NAME = "repositories";
    public static final String REPOINFO_REPONAME_KEY = "name";
    public static final String MAIN_KEY = "id";
    public static final String CLUSTER_NODES_TABLE_NAME = "cluster_nodes";
    public static final String CLUSTER_NODES_NODEID_KEY = "nodeid";
    public static final String CLUSTER_NODES_CREATED_KEY = "created";
    public static final String CLUSTER_INVALS_TABLE_NAME = "cluster_invals";
    public static final String CLUSTER_INVALS_NODEID_KEY = "nodeid";
    public static final String CLUSTER_INVALS_ID_KEY = "id";
    public static final String CLUSTER_INVALS_FRAGMENTS_KEY = "fragments";
    public static final String CLUSTER_INVALS_KIND_KEY = "kind";
    public static final String MAIN_PRIMARY_TYPE_PROP = "ecm:primaryType";
    public static final String MAIN_PRIMARY_TYPE_KEY = "primarytype";
    public static final String MAIN_MIXIN_TYPES_PROP = "ecm:mixinTypes";
    public static final String MAIN_MIXIN_TYPES_KEY = "mixintypes";
    public static final String MAIN_BASE_VERSION_PROP = "ecm:baseVersion";
    public static final String MAIN_BASE_VERSION_KEY = "baseversionid";
    public static final String MAIN_CHECKED_IN_PROP = "ecm:isCheckedIn";
    public static final String MAIN_CHECKED_IN_KEY = "ischeckedin";
    public static final String MAIN_MAJOR_VERSION_PROP = "ecm:majorVersion";
    public static final String MAIN_MAJOR_VERSION_KEY = "majorversion";
    public static final String MAIN_MINOR_VERSION_PROP = "ecm:minorVersion";
    public static final String MAIN_MINOR_VERSION_KEY = "minorversion";
    public static final String MAIN_IS_VERSION_PROP = "ecm:isVersion";
    public static final String MAIN_IS_VERSION_KEY = "isversion";
    public static final String UID_SCHEMA_NAME = "uid";
    public static final String UID_MAJOR_VERSION_KEY = "major_version";
    public static final String UID_MINOR_VERSION_KEY = "minor_version";
    public static final String HIER_TABLE_NAME = "hierarchy";
    public static final String HIER_PARENT_KEY = "parentid";
    public static final String HIER_CHILD_NAME_KEY = "name";
    public static final String HIER_CHILD_POS_KEY = "pos";
    public static final String HIER_CHILD_ISPROPERTY_KEY = "isproperty";
    public static final String ANCESTORS_TABLE_NAME = "ancestors";
    public static final String ANCESTORS_ANCESTOR_KEY = "ancestors";
    public static final String COLL_TABLE_POS_KEY = "pos";
    public static final String COLL_TABLE_VALUE_KEY = "item";
    public static final String MISC_TABLE_NAME = "misc";
    public static final String MISC_LIFECYCLE_POLICY_PROP = "ecm:lifeCyclePolicy";
    public static final String MISC_LIFECYCLE_POLICY_KEY = "lifecyclepolicy";
    public static final String MISC_LIFECYCLE_STATE_PROP = "ecm:lifeCycleState";
    public static final String MISC_LIFECYCLE_STATE_KEY = "lifecyclestate";
    public static final String ACL_TABLE_NAME = "acls";
    public static final String ACL_PROP = "ecm:acl";
    public static final String ACL_POS_KEY = "pos";
    public static final String ACL_NAME_KEY = "name";
    public static final String ACL_GRANT_KEY = "grant";
    public static final String ACL_PERMISSION_KEY = "permission";
    public static final String ACL_USER_KEY = "user";
    public static final String ACL_GROUP_KEY = "group";
    public static final String VERSION_TABLE_NAME = "versions";
    public static final String VERSION_VERSIONABLE_PROP = "ecm:versionableId";
    public static final String VERSION_VERSIONABLE_KEY = "versionableid";
    public static final String VERSION_CREATED_PROP = "ecm:versionCreated";
    public static final String VERSION_CREATED_KEY = "created";
    public static final String VERSION_LABEL_PROP = "ecm:versionLabel";
    public static final String VERSION_LABEL_KEY = "label";
    public static final String VERSION_DESCRIPTION_PROP = "ecm:versionDescription";
    public static final String VERSION_DESCRIPTION_KEY = "description";
    public static final String VERSION_IS_LATEST_PROP = "ecm:isLatestVersion";
    public static final String VERSION_IS_LATEST_KEY = "islatest";
    public static final String VERSION_IS_LATEST_MAJOR_PROP = "ecm:isLatestMajorVersion";
    public static final String VERSION_IS_LATEST_MAJOR_KEY = "islatestmajor";
    public static final String PROXY_TYPE = "ecm:proxy";
    public static final String PROXY_TABLE_NAME = "proxies";
    public static final String PROXY_TARGET_PROP = "ecm:proxyTargetId";
    public static final String PROXY_TARGET_KEY = "targetid";
    public static final String PROXY_VERSIONABLE_PROP = "ecm:proxyVersionableId";
    public static final String PROXY_VERSIONABLE_KEY = "versionableid";
    public static final String LOCK_TABLE_NAME = "locks";
    public static final String LOCK_OWNER_PROP = "ecm:lockOwner";
    public static final String LOCK_OWNER_KEY = "owner";
    public static final String LOCK_CREATED_PROP = "ecm:lockCreated";
    public static final String LOCK_CREATED_KEY = "created";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";
    public static final String FULLTEXT_TABLE_NAME = "fulltext";
    public static final String FULLTEXT_JOBID_PROP = "ecm:fulltextJobId";
    public static final String FULLTEXT_JOBID_KEY = "jobid";
    public static final String FULLTEXT_FULLTEXT_PROP = "ecm:fulltext";
    public static final String FULLTEXT_FULLTEXT_KEY = "fulltext";
    public static final String FULLTEXT_SIMPLETEXT_PROP = "ecm:simpleText";
    public static final String FULLTEXT_SIMPLETEXT_KEY = "simpletext";
    public static final String FULLTEXT_BINARYTEXT_PROP = "ecm:binaryText";
    public static final String FULLTEXT_BINARYTEXT_KEY = "binarytext";
    public static final String HIER_READ_ACL_TABLE_NAME = "hierarchy_read_acl";
    public static final String HIER_READ_ACL_ID = "id";
    public static final String HIER_READ_ACL_ACL_ID = "acl_id";
    public static final String FIELD_TYPE_LARGETEXT = "largetext";
    public static final List<String> COMMON_SIMPLE_FRAGMENTS = Arrays.asList("versions", "misc");
    public static final String[] COMMON_COLLECTION_FRAGMENTS = new String[]{"acls"};
    public static final String[] ALWAYS_PREFETCHED_FRAGMENTS = new String[]{"acls", "versions", "misc"};
    protected final RepositoryDescriptor repositoryDescriptor;
    private final AtomicLong temporaryIdCounter = new AtomicLong(0L);
    private final Map<String, Set<String>> documentTypesSchemas;
    private final Map<String, Set<String>> mixinsDocumentTypes;
    private final Map<String, Set<String>> mixinsSchemas;
    private final Map<String, Type> specialPropertyTypes;
    private final HashMap<String, Map<String, ModelProperty>> schemaPropertyKeyInfos;
    private final HashMap<String, Map<String, ModelProperty>> schemaPropertyInfos;
    private final HashMap<String, Map<String, ModelProperty>> mixinPropertyInfos;
    private final Map<String, ModelProperty> sharedPropertyInfos;
    private final Map<String, ModelProperty> mergedPropertyInfos;
    private final Map<String, Map<String, ModelProperty>> schemaPathPropertyInfos;
    private final Map<String, Set<String>> schemaSimpleTextPaths;
    private final Map<String, ModelProperty> allPathPropertyInfos;
    private final Map<String, Map<String, ColumnType>> fragmentsKeys;
    private final Map<String, List<String>> binaryPropertyInfos;
    private final Map<String, PropertyType> collectionTables;
    private final Map<String, String> collectionOrderBy;
    private final Map<String, String> schemaFragment;
    protected final Map<String, Set<String>> typeCollectionFragments;
    protected final Map<String, Set<String>> typeFragments;
    protected final Map<String, Set<String>> mixinFragments;
    protected final Map<String, Set<String>> typePrefetchedFragments;
    protected final Map<String, Set<String>> documentTypesFacets;
    protected final Map<String, String> documentSuperTypes;
    protected final Map<String, Set<String>> documentSubTypes;
    protected final Map<String, Set<String>> fieldFragments;
    public final ModelFulltext fulltextInfo;
    private final boolean materializeFulltextSyntheticColumn;

    public Model(ModelSetup modelSetup) throws StorageException {
        this.repositoryDescriptor = modelSetup.repositoryDescriptor;
        this.materializeFulltextSyntheticColumn = modelSetup.materializeFulltextSyntheticColumn;
        this.documentTypesSchemas = new HashMap<String, Set<String>>();
        this.mixinsDocumentTypes = new HashMap<String, Set<String>>();
        this.mixinsSchemas = new HashMap<String, Set<String>>();
        this.schemaPropertyKeyInfos = new HashMap();
        this.schemaPropertyInfos = new HashMap();
        this.mixinPropertyInfos = new HashMap();
        this.sharedPropertyInfos = new HashMap<String, ModelProperty>();
        this.mergedPropertyInfos = new HashMap<String, ModelProperty>();
        this.schemaPathPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.schemaSimpleTextPaths = new HashMap<String, Set<String>>();
        this.allPathPropertyInfos = new HashMap<String, ModelProperty>();
        this.fulltextInfo = new ModelFulltext();
        this.fragmentsKeys = new HashMap<String, Map<String, ColumnType>>();
        this.binaryPropertyInfos = new HashMap<String, List<String>>();
        this.collectionTables = new HashMap<String, PropertyType>();
        this.collectionOrderBy = new HashMap<String, String>();
        this.schemaFragment = new HashMap<String, String>();
        this.typeFragments = new HashMap<String, Set<String>>();
        this.mixinFragments = new HashMap<String, Set<String>>();
        this.typeCollectionFragments = new HashMap<String, Set<String>>();
        this.typePrefetchedFragments = new HashMap<String, Set<String>>();
        this.fieldFragments = new HashMap<String, Set<String>>();
        this.documentTypesFacets = new HashMap<String, Set<String>>();
        this.documentSuperTypes = new HashMap<String, String>();
        this.documentSubTypes = new HashMap<String, Set<String>>();
        this.specialPropertyTypes = new HashMap<String, Type>();
        this.initMainModel();
        this.initVersionsModel();
        this.initProxiesModel();
        this.initLocksModel();
        this.initAclModel();
        this.initMiscModel();
        this.initModels(modelSetup.schemaManager);
        if (!this.repositoryDescriptor.fulltextDisabled) {
            this.initFullTextModel();
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public Serializable generateNewId() {
        return UUID.randomUUID().toString();
    }

    public Serializable unHackStringId(String id) {
        return id;
    }

    private void addPropertyInfo(String schemaName, String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        ModelProperty previous;
        Map<String, ModelProperty> propertyInfos;
        Map<String, ModelProperty> propertyKeyInfos;
        if (schemaName == null) {
            propertyKeyInfos = null;
            propertyInfos = this.sharedPropertyInfos;
        } else {
            propertyKeyInfos = this.schemaPropertyKeyInfos.get(schemaName);
            if (propertyKeyInfos == null) {
                propertyKeyInfos = new HashMap<String, ModelProperty>();
                this.schemaPropertyKeyInfos.put(schemaName, propertyKeyInfos);
            }
            if ((propertyInfos = this.schemaPropertyInfos.get(schemaName)) == null) {
                propertyInfos = new HashMap<String, ModelProperty>();
                this.schemaPropertyInfos.put(schemaName, propertyInfos);
            }
        }
        ModelProperty propertyInfo = new ModelProperty(propertyType, fragmentName, fragmentKey, readonly);
        propertyInfos.put(propertyName, propertyInfo);
        if (propertyKeyInfos != null && fragmentKey != null) {
            propertyKeyInfos.put(fragmentKey, propertyInfo);
        }
        if (fragmentKey != null) {
            Map<String, ColumnType> fragmentKeys = this.fragmentsKeys.get(fragmentName);
            if (fragmentKeys == null) {
                fragmentKeys = new LinkedHashMap<String, ColumnType>();
                this.fragmentsKeys.put(fragmentName, fragmentKeys);
            }
            fragmentKeys.put(fragmentKey, type);
            if (type.spec == ColumnSpec.BLOBID) {
                List<String> keys = this.binaryPropertyInfos.get(fragmentName);
                if (keys == null) {
                    keys = new ArrayList<String>(1);
                    this.binaryPropertyInfos.put(fragmentName, keys);
                }
                keys.add(fragmentKey);
            }
        }
        if (coreType != null) {
            this.specialPropertyTypes.put(propertyName, coreType);
        }
        if ((previous = this.mergedPropertyInfos.get(propertyName)) == null) {
            this.mergedPropertyInfos.put(propertyName, propertyInfo);
        } else {
            log.debug((Object)String.format("Schemas '%s' and '%s' both have a property '%s', unqualified reference in queries will use schema '%1$s'", previous.fragmentName, fragmentName, propertyName));
        }
        if (!propertyName.contains(":") && (previous = this.mergedPropertyInfos.get(propertyName = schemaName + ':' + propertyName)) == null) {
            this.mergedPropertyInfos.put(propertyName, propertyInfo);
        }
    }

    private void inferTypePropertyInfos(String typeName, String[] schemaNames) {
        Map<String, ModelProperty> propertyInfos = this.schemaPropertyInfos.get(typeName);
        if (propertyInfos == null) {
            propertyInfos = new HashMap<String, ModelProperty>();
            this.schemaPropertyInfos.put(typeName, propertyInfos);
        }
        for (String schemaName : schemaNames) {
            Map<String, ModelProperty> infos = this.schemaPropertyInfos.get(schemaName);
            if (infos == null) continue;
            for (Map.Entry<String, ModelProperty> info : infos.entrySet()) {
                propertyInfos.put(info.getKey(), info.getValue());
            }
        }
    }

    private void inferMixinPropertyInfos(String mixin, String[] schemaNames) {
        Map<String, ModelProperty> propertyInfos = this.schemaPropertyInfos.get(mixin);
        if (propertyInfos == null) {
            propertyInfos = new HashMap<String, ModelProperty>();
            this.mixinPropertyInfos.put(mixin, propertyInfos);
        }
        for (String schemaName : schemaNames) {
            Map<String, ModelProperty> infos = this.schemaPropertyInfos.get(schemaName);
            if (infos == null) continue;
            for (Map.Entry<String, ModelProperty> info : infos.entrySet()) {
                propertyInfos.put(info.getKey(), info.getValue());
            }
        }
    }

    private void inferTypePropertyPaths(DocumentType documentType) {
        for (Schema schema : documentType.getSchemas()) {
            if (schema == null) continue;
            this.inferSchemaPropertyPaths(schema);
        }
    }

    private void inferSchemaPropertyPaths(Schema schema) {
        String schemaName = schema.getName();
        if (this.schemaPathPropertyInfos.containsKey(schemaName)) {
            return;
        }
        HashMap<String, ModelProperty> propertyInfoByPath = new HashMap<String, ModelProperty>();
        this.inferTypePropertyPaths((ComplexType)schema, "", propertyInfoByPath, null);
        this.schemaPathPropertyInfos.put(schemaName, propertyInfoByPath);
        HashMap<String, ModelProperty> alsoWithPrefixes = new HashMap<String, ModelProperty>(propertyInfoByPath);
        if (schema.getNamespace().prefix.isEmpty()) {
            for (Map.Entry e : propertyInfoByPath.entrySet()) {
                String key = (String)e.getKey();
                if (key.contains("/")) continue;
                alsoWithPrefixes.put(schemaName + ':' + key, (ModelProperty)e.getValue());
            }
        }
        this.allPathPropertyInfos.putAll(alsoWithPrefixes);
        HashSet simplePaths = new HashSet();
        for (Map.Entry entry : propertyInfoByPath.entrySet()) {
            ModelProperty pi = (ModelProperty)entry.getValue();
            if (pi == ModelProperty.NONE || pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
            simplePaths.add(entry.getKey());
        }
        this.schemaSimpleTextPaths.put(schemaName, simplePaths);
    }

    private void inferTypePropertyPaths(ComplexType complexType, String prefix, Map<String, ModelProperty> propertyInfoByPath, Set<String> done) {
        String typeName;
        if (done == null) {
            done = new LinkedHashSet<String>();
        }
        if (done.contains(typeName = complexType.getName())) {
            log.warn((Object)("Complex type " + typeName + " refers to itself recursively: " + done));
            return;
        }
        done.add(typeName);
        for (Field field : complexType.getFields()) {
            Type listFieldType;
            String propertyName = field.getName().getPrefixedName();
            String path = prefix + propertyName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                propertyInfoByPath.put(path, ModelProperty.NONE);
                this.inferTypePropertyPaths((ComplexType)fieldType, path + '/', propertyInfoByPath, done);
                continue;
            }
            if (fieldType.isListType() && !(listFieldType = ((ListType)fieldType).getFieldType()).isSimpleType()) {
                propertyInfoByPath.put(path + "/*", ModelProperty.NONE);
                this.inferTypePropertyPaths((ComplexType)listFieldType, path + "/*/", propertyInfoByPath, done);
                continue;
            }
            ModelProperty pi = this.schemaPropertyInfos.get(typeName).get(propertyName);
            propertyInfoByPath.put(path, pi);
            if (!pi.propertyType.isArray()) continue;
            propertyInfoByPath.put(path + "/*", pi);
        }
        done.remove(typeName);
    }

    private void inferFulltextInfo(SchemaManager schemaManager) {
        List<RepositoryDescriptor.FulltextIndexDescriptor> descs = this.repositoryDescriptor.fulltextIndexes;
        if (descs == null) {
            descs = new ArrayList<RepositoryDescriptor.FulltextIndexDescriptor>(1);
        }
        if (descs.isEmpty()) {
            descs.add(new RepositoryDescriptor.FulltextIndexDescriptor());
        }
        for (RepositoryDescriptor.FulltextIndexDescriptor desc : descs) {
            String name = desc.name == null ? FULLTEXT_DEFAULT_INDEX : desc.name;
            this.fulltextInfo.indexNames.add(name);
            this.fulltextInfo.indexAnalyzer.put(name, desc.analyzer == null ? this.repositoryDescriptor.fulltextAnalyzer : desc.analyzer);
            this.fulltextInfo.indexCatalog.put(name, desc.catalog == null ? this.repositoryDescriptor.fulltextCatalog : desc.catalog);
            if (desc.fields == null) {
                desc.fields = new HashSet<String>();
            }
            if (desc.excludeFields == null) {
                desc.excludeFields = new HashSet<String>();
            }
            if (desc.fields.size() == 1 && desc.excludeFields.isEmpty()) {
                this.fulltextInfo.fieldToIndexName.put(desc.fields.iterator().next(), name);
            }
            if (desc.fieldType != null) {
                if (desc.fieldType.equals("string")) {
                    this.fulltextInfo.indexesAllSimple.add(name);
                } else if (desc.fieldType.equals("blob")) {
                    this.fulltextInfo.indexesAllBinary.add(name);
                } else {
                    log.error((Object)("Ignoring unknow repository fulltext configuration fieldType: " + desc.fieldType));
                }
            }
            if (desc.fields.isEmpty() && desc.fieldType == null) {
                this.fulltextInfo.indexesAllSimple.add(name);
                this.fulltextInfo.indexesAllBinary.add(name);
            }
            if (this.repositoryDescriptor.fulltextExcludedTypes != null) {
                this.fulltextInfo.excludedTypes.addAll(this.repositoryDescriptor.fulltextExcludedTypes);
            }
            if (this.repositoryDescriptor.fulltextIncludedTypes != null) {
                this.fulltextInfo.includedTypes.addAll(this.repositoryDescriptor.fulltextIncludedTypes);
            }
            for (Set fields : Arrays.asList(desc.fields, desc.excludeFields)) {
                for (String path : fields) {
                    Map<String, Set<String>> propPathsByIndex;
                    Map<String, Set<String>> indexesByPropPath;
                    ModelProperty pi = this.allPathPropertyInfos.get(path);
                    if (pi == null) {
                        log.error((Object)String.format("Ignoring unknown property '%s' in fulltext configuration: %s", path, name));
                        continue;
                    }
                    if (pi.propertyType == PropertyType.STRING || pi.propertyType == PropertyType.ARRAY_STRING) {
                        indexesByPropPath = fields == desc.fields ? this.fulltextInfo.indexesByPropPathSimple : this.fulltextInfo.indexesByPropPathExcludedSimple;
                        propPathsByIndex = fields == desc.fields ? this.fulltextInfo.propPathsByIndexSimple : this.fulltextInfo.propPathsExcludedByIndexSimple;
                    } else if (pi.propertyType == PropertyType.BINARY) {
                        indexesByPropPath = fields == desc.fields ? this.fulltextInfo.indexesByPropPathBinary : this.fulltextInfo.indexesByPropPathExcludedBinary;
                        propPathsByIndex = fields == desc.fields ? this.fulltextInfo.propPathsByIndexBinary : this.fulltextInfo.propPathsExcludedByIndexBinary;
                    } else {
                        log.error((Object)String.format("Ignoring property '%s' with bad type %s in fulltext configuration: %s", new Object[]{path, pi.propertyType, name}));
                        continue;
                    }
                    Set<String> indexes = indexesByPropPath.get(path);
                    if (indexes == null) {
                        indexes = new HashSet<String>();
                        indexesByPropPath.put(path, indexes);
                    }
                    indexes.add(name);
                    Set<String> paths = propPathsByIndex.get(name);
                    if (paths == null) {
                        paths = new LinkedHashSet<String>();
                        propPathsByIndex.put(name, paths);
                    }
                    paths.add(path);
                }
            }
        }
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            if (!documentType.hasFacet("NotFulltextIndexable")) continue;
            this.fulltextInfo.excludedTypes.add(documentType.getName());
        }
    }

    public ModelProperty getPropertyInfo(String typeName, String propertyName) {
        Map<String, ModelProperty> propertyInfos = this.schemaPropertyInfos.get(typeName);
        if (propertyInfos == null) {
            return null;
        }
        ModelProperty propertyInfo = propertyInfos.get(propertyName);
        return propertyInfo != null ? propertyInfo : this.sharedPropertyInfos.get(propertyName);
    }

    public Map<String, ModelProperty> getMixinPropertyInfos(String mixin) {
        return this.mixinPropertyInfos.get(mixin);
    }

    public ModelProperty getMixinPropertyInfo(String mixin, String propertyName) {
        Map<String, ModelProperty> propertyInfos = this.mixinPropertyInfos.get(mixin);
        if (propertyInfos == null) {
            return null;
        }
        return propertyInfos.get(propertyName);
    }

    public ModelProperty getPropertyInfo(String propertyName) {
        return this.mergedPropertyInfos.get(propertyName);
    }

    public ModelProperty getPathPropertyInfo(String xpath) {
        return this.allPathPropertyInfos.get(xpath);
    }

    public Set<String> getPropertyInfoNames() {
        return this.mergedPropertyInfos.keySet();
    }

    public ModelProperty getPathPropertyInfo(String primaryType, String[] mixinTypes, String path) {
        for (String schema : this.getAllSchemas(primaryType, mixinTypes)) {
            ModelProperty pi;
            Map<String, ModelProperty> propertyInfoByPath = this.schemaPathPropertyInfos.get(schema);
            if (propertyInfoByPath == null || (pi = propertyInfoByPath.get(path)) == null) continue;
            return pi;
        }
        return null;
    }

    public Set<String> getSimpleTextPropertyPaths(String primaryType, String[] mixinTypes) {
        HashSet<String> paths = new HashSet<String>();
        for (String schema : this.getAllSchemas(primaryType, mixinTypes)) {
            Set<String> p = this.schemaSimpleTextPaths.get(schema);
            if (p == null) continue;
            paths.addAll(p);
        }
        return paths;
    }

    public Set<String> getAllSchemas(String primaryType, String[] mixinTypes) {
        LinkedHashSet<String> schemas = new LinkedHashSet<String>();
        Set<String> s = this.documentTypesSchemas.get(primaryType);
        if (s != null) {
            schemas.addAll(s);
        }
        for (String mixin : mixinTypes) {
            s = this.mixinsSchemas.get(mixin);
            if (s == null) continue;
            schemas.addAll(s);
        }
        return schemas;
    }

    public ModelFulltext getFulltextInfo() {
        return this.fulltextInfo;
    }

    public PropertyType getFulltextFieldType(String fragmentName, String fragmentKey) {
        if (fragmentKey == null) {
            PropertyType type = this.collectionTables.get(fragmentName);
            if (type == PropertyType.ARRAY_STRING || type == PropertyType.ARRAY_BINARY) {
                return type.getArrayBaseType();
            }
            return null;
        }
        Map<String, ModelProperty> infos = this.schemaPropertyKeyInfos.get(fragmentName);
        if (infos == null) {
            return null;
        }
        ModelProperty info = infos.get(fragmentKey);
        if (info != null && info.fulltext) {
            return info.propertyType;
        }
        return null;
    }

    private void addCollectionFragmentInfos(String fragmentName, PropertyType propertyType, String orderBy, Map<String, ColumnType> keysType) {
        this.collectionTables.put(fragmentName, propertyType);
        this.collectionOrderBy.put(fragmentName, orderBy);
        Map<String, ColumnType> old = this.fragmentsKeys.get(fragmentName);
        if (old == null) {
            this.fragmentsKeys.put(fragmentName, keysType);
        } else {
            old.putAll(keysType);
        }
    }

    public Type getSpecialPropertyType(String propertyName) {
        return this.specialPropertyTypes.get(propertyName);
    }

    public PropertyType getCollectionFragmentType(String fragmentName) {
        return this.collectionTables.get(fragmentName);
    }

    public boolean isCollectionFragment(String fragmentName) {
        return this.collectionTables.containsKey(fragmentName);
    }

    public String getCollectionOrderBy(String fragmentName) {
        return this.collectionOrderBy.get(fragmentName);
    }

    public Set<String> getFragmentNames() {
        return this.fragmentsKeys.keySet();
    }

    public Map<String, ColumnType> getFragmentKeysType(String fragmentName) {
        return this.fragmentsKeys.get(fragmentName);
    }

    public Map<String, List<String>> getBinaryPropertyInfos() {
        return this.binaryPropertyInfos;
    }

    protected void addTypeCollectionFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typeCollectionFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typeCollectionFragments.put(typeName, fragments);
        }
        fragments.add(fragmentName);
        this.addTypeFragment(typeName, fragmentName);
    }

    protected void addTypeFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typeFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typeFragments.put(typeName, fragments);
        }
        if (fragmentName != null) {
            fragments.add(fragmentName);
        }
    }

    protected void addMixinFragment(String mixin, String fragmentName) {
        Set<String> fragments = this.mixinFragments.get(mixin);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.mixinFragments.put(mixin, fragments);
        }
        fragments.add(fragmentName);
    }

    protected void addFieldFragment(Field field, String fragmentName) {
        String fieldName = field.getName().toString();
        Set<String> fragments = this.fieldFragments.get(fieldName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.fieldFragments.put(fieldName, fragments);
        }
        fragments.add(fragmentName);
    }

    protected void addTypePrefetchedFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typePrefetchedFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typePrefetchedFragments.put(typeName, fragments);
        }
        fragments.add(fragmentName);
    }

    public Set<String> getTypeFragments(String typeName) {
        return this.typeFragments.get(typeName);
    }

    public Set<String> getMixinFragments(String mixin) {
        return this.mixinFragments.get(mixin);
    }

    protected Set<String> getFieldFragments(String fieldName) {
        return this.fieldFragments.get(fieldName);
    }

    public Set<String> getTypePrefetchedFragments(String typeName) {
        return this.typePrefetchedFragments.get(typeName);
    }

    public boolean isType(String typeName) {
        return this.typeFragments.containsKey(typeName);
    }

    public boolean isDocumentType(String typeName) {
        return this.documentTypesFacets.containsKey(typeName);
    }

    public String getDocumentSuperType(String typeName) {
        return this.documentSuperTypes.get(typeName);
    }

    public Set<String> getDocumentSubTypes(String typeName) {
        return this.documentSubTypes.get(typeName);
    }

    public Set<String> getDocumentTypes() {
        return this.documentTypesFacets.keySet();
    }

    public Set<String> getDocumentTypeFacets(String typeName) {
        Set<String> facets = this.documentTypesFacets.get(typeName);
        return facets == null ? Collections.emptySet() : facets;
    }

    public Set<String> getMixinDocumentTypes(String mixin) {
        Set<String> types = this.mixinsDocumentTypes.get(mixin);
        return types == null ? Collections.emptySet() : types;
    }

    public Map<String, Set<Serializable>> getPerFragmentIds(Map<Serializable, RowMapper.IdWithTypes> idToTypes) {
        HashMap<String, Set<Serializable>> allFragmentIds = new HashMap<String, Set<Serializable>>();
        for (Map.Entry<Serializable, RowMapper.IdWithTypes> e : idToTypes.entrySet()) {
            Serializable id = e.getKey();
            RowMapper.IdWithTypes typeInfo = e.getValue();
            for (String fragmentName : this.getTypeFragments(typeInfo)) {
                HashSet<Serializable> fragmentIds = (HashSet<Serializable>)allFragmentIds.get(fragmentName);
                if (fragmentIds == null) {
                    fragmentIds = new HashSet<Serializable>();
                    allFragmentIds.put(fragmentName, fragmentIds);
                }
                fragmentIds.add(id);
            }
        }
        return allFragmentIds;
    }

    public Set<String> getTypeFragments(RowMapper.IdWithTypes typeInfo) {
        String[] mixins;
        HashSet<String> fragmentNames = new HashSet<String>();
        fragmentNames.add(HIER_TABLE_NAME);
        Set<String> tf = this.getTypeFragments(typeInfo.primaryType);
        if (tf != null) {
            fragmentNames.addAll(tf);
        }
        if ((mixins = typeInfo.mixinTypes) != null) {
            for (String mixin : mixins) {
                Set<String> mf = this.getMixinFragments(mixin);
                if (mf == null) continue;
                fragmentNames.addAll(mf);
            }
        }
        return fragmentNames;
    }

    private PropertyType mainIdType() {
        return PropertyType.STRING;
    }

    /*
     * WARNING - void declaration
     */
    private void initModels(SchemaManager schemaManager) throws StorageException {
        String fragmentName;
        log.debug((Object)("Schemas fields from descriptor: " + this.repositoryDescriptor.schemaFields));
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            String typeName = documentType.getName();
            this.addTypeFragment(typeName, null);
            HashSet<String> docTypeSchemas = new HashSet<String>();
            for (Schema schema : documentType.getSchemas()) {
                if (schema == null) continue;
                try {
                    docTypeSchemas.add(schema.getName());
                    fragmentName = this.initTypeModel((ComplexType)schema);
                    this.addTypeFragment(typeName, fragmentName);
                    Set<String> cols = this.typeCollectionFragments.get(schema.getName());
                    if (cols == null) continue;
                    for (String colFrag : cols) {
                        this.addTypeCollectionFragment(typeName, colFrag);
                    }
                }
                catch (Exception e) {
                    throw new StorageException(String.format("Error initializing schema '%s' for document type '%s'", schema.getName(), typeName), e);
                }
            }
            try {
                this.documentTypesSchemas.put(typeName, docTypeSchemas);
                this.inferTypePropertyInfos(typeName, documentType.getSchemaNames());
                this.inferTypePropertyPaths(documentType);
            }
            catch (Exception e) {
                throw new StorageException(String.format("Error initializing schemas for document type '%s'", typeName), e);
            }
            for (String fragmentName2 : this.getCommonSimpleFragments(typeName)) {
                this.addTypeFragment(typeName, fragmentName2);
            }
            for (String fragmentName3 : COMMON_COLLECTION_FRAGMENTS) {
                this.addTypeCollectionFragment(typeName, fragmentName3);
            }
            PrefetchInfo prefetch = documentType.getPrefetchInfo();
            if (prefetch != null) {
                Set<String> typeFragments = this.getTypeFragments(typeName);
                for (String fieldName : prefetch.getFields()) {
                    Set<String> fragments = this.getFieldFragments(fieldName);
                    if (fragments == null) continue;
                    for (String fragment : fragments) {
                        if (!typeFragments.contains(fragment)) continue;
                        this.addTypePrefetchedFragment(typeName, fragment);
                    }
                }
                for (String schemaName : prefetch.getSchemas()) {
                    Set<String> collectionFragments;
                    String fragment = this.schemaFragment.get(schemaName);
                    if (fragment != null) {
                        this.addTypePrefetchedFragment(typeName, fragment);
                    }
                    if ((collectionFragments = this.typeCollectionFragments.get(typeName)) == null) continue;
                    for (String fragmentName4 : collectionFragments) {
                        this.addTypePrefetchedFragment(typeName, fragmentName4);
                    }
                }
            }
            for (String fragmentName5 : ALWAYS_PREFETCHED_FRAGMENTS) {
                this.addTypePrefetchedFragment(typeName, fragmentName5);
            }
            log.debug((Object)("Fragments for type " + typeName + ": " + this.getTypeFragments(typeName) + ", prefetch: " + this.getTypePrefetchedFragments(typeName)));
            Set mixins = documentType.getFacets();
            this.documentTypesFacets.put(typeName, new HashSet(mixins));
            for (String mixin : mixins) {
                Set<String> mixinTypes = this.mixinsDocumentTypes.get(mixin);
                if (mixinTypes == null) {
                    mixinTypes = new HashSet<String>();
                    this.mixinsDocumentTypes.put(mixin, mixinTypes);
                }
                mixinTypes.add(typeName);
            }
            Type superType = documentType.getSuperType();
            if (superType == null) continue;
            String superTypeName = superType.getName();
            this.documentSuperTypes.put(typeName, superTypeName);
        }
        Iterator<String> i$ = this.getDocumentTypes().iterator();
        while (i$.hasNext()) {
            String type;
            String superType = type = i$.next();
            do {
                void var5_11;
                Set<String> set;
                if ((set = this.documentSubTypes.get(superType)) == null) {
                    HashSet hashSet = new HashSet();
                    this.documentSubTypes.put(superType, hashSet);
                }
                var5_11.add(type);
            } while ((superType = this.documentSuperTypes.get(superType)) != null);
        }
        if (!this.repositoryDescriptor.fulltextDisabled) {
            this.inferFulltextInfo(schemaManager);
        }
        for (DocumentType documentType : schemaManager.getFacets()) {
            String mixin = documentType.getName();
            HashSet<String> mixinSchemas = new HashSet<String>();
            for (Schema schema : documentType.getSchemas()) {
                Set<String> cols;
                if (schema == null) continue;
                mixinSchemas.add(schema.getName());
                fragmentName = this.initTypeModel((ComplexType)schema);
                if (fragmentName != null) {
                    this.addMixinFragment(mixin, fragmentName);
                }
                if ((cols = this.typeCollectionFragments.get(schema.getName())) != null) {
                    for (String colFrag : cols) {
                        this.addMixinFragment(mixin, colFrag);
                    }
                }
                this.inferSchemaPropertyPaths(schema);
            }
            this.mixinsSchemas.put(mixin, mixinSchemas);
            this.inferMixinPropertyInfos(mixin, documentType.getSchemaNames());
            log.debug((Object)("Fragments for facet " + mixin + ": " + this.getMixinFragments(mixin)));
        }
    }

    protected List<String> getCommonSimpleFragments(String typeName) {
        List<String> fragments = COMMON_SIMPLE_FRAGMENTS;
        if (!this.repositoryDescriptor.fulltextDisabled && this.fulltextInfo.isFulltextIndexable(typeName)) {
            fragments = new ArrayList<String>(fragments);
            fragments.add("fulltext");
        }
        return fragments;
    }

    private void initMainModel() {
        this.addPropertyInfo(null, MAIN_PRIMARY_TYPE_PROP, PropertyType.STRING, HIER_TABLE_NAME, MAIN_PRIMARY_TYPE_KEY, true, null, ColumnType.SYSNAME);
        this.addPropertyInfo(null, MAIN_MIXIN_TYPES_PROP, PropertyType.STRING, HIER_TABLE_NAME, MAIN_MIXIN_TYPES_KEY, false, null, ColumnType.SYSNAMEARRAY);
        this.addPropertyInfo(null, MAIN_CHECKED_IN_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_CHECKED_IN_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(null, MAIN_BASE_VERSION_PROP, this.mainIdType(), HIER_TABLE_NAME, MAIN_BASE_VERSION_KEY, false, (Type)StringType.INSTANCE, ColumnType.NODEVAL);
        this.addPropertyInfo(null, MAIN_MAJOR_VERSION_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_MAJOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
        this.addPropertyInfo(null, MAIN_MINOR_VERSION_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_MINOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
        this.addPropertyInfo(null, MAIN_IS_VERSION_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_IS_VERSION_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
    }

    private void initMiscModel() {
        this.addPropertyInfo(null, MISC_LIFECYCLE_POLICY_PROP, PropertyType.STRING, MISC_TABLE_NAME, MISC_LIFECYCLE_POLICY_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, MISC_LIFECYCLE_STATE_PROP, PropertyType.STRING, MISC_TABLE_NAME, MISC_LIFECYCLE_STATE_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
    }

    private void initVersionsModel() {
        this.addPropertyInfo(null, VERSION_VERSIONABLE_PROP, this.mainIdType(), VERSION_TABLE_NAME, "versionableid", false, (Type)StringType.INSTANCE, ColumnType.NODEVAL);
        this.addPropertyInfo(null, VERSION_CREATED_PROP, PropertyType.DATETIME, VERSION_TABLE_NAME, "created", false, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
        this.addPropertyInfo(null, VERSION_LABEL_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_LABEL_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, VERSION_DESCRIPTION_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_DESCRIPTION_KEY, false, (Type)StringType.INSTANCE, ColumnType.STRING);
        this.addPropertyInfo(null, VERSION_IS_LATEST_PROP, PropertyType.BOOLEAN, VERSION_TABLE_NAME, VERSION_IS_LATEST_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(null, VERSION_IS_LATEST_MAJOR_PROP, PropertyType.BOOLEAN, VERSION_TABLE_NAME, VERSION_IS_LATEST_MAJOR_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
    }

    private void initProxiesModel() {
        this.addPropertyInfo(PROXY_TYPE, PROXY_TARGET_PROP, this.mainIdType(), PROXY_TABLE_NAME, PROXY_TARGET_KEY, false, (Type)StringType.INSTANCE, ColumnType.NODEIDFKNP);
        this.addPropertyInfo(PROXY_TYPE, PROXY_VERSIONABLE_PROP, this.mainIdType(), PROXY_TABLE_NAME, "versionableid", false, (Type)StringType.INSTANCE, ColumnType.NODEVAL);
        this.addTypeFragment(PROXY_TYPE, PROXY_TABLE_NAME);
    }

    private void initLocksModel() {
        this.addPropertyInfo(null, LOCK_OWNER_PROP, PropertyType.STRING, LOCK_TABLE_NAME, LOCK_OWNER_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, LOCK_CREATED_PROP, PropertyType.DATETIME, LOCK_TABLE_NAME, "created", false, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
    }

    private void initFullTextModel() {
        this.addPropertyInfo(null, FULLTEXT_JOBID_PROP, PropertyType.STRING, "fulltext", FULLTEXT_JOBID_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        for (String indexName : this.fulltextInfo.indexNames) {
            String suffix = this.getFulltextIndexSuffix(indexName);
            if (this.materializeFulltextSyntheticColumn) {
                this.addPropertyInfo(null, FULLTEXT_FULLTEXT_PROP + suffix, PropertyType.STRING, "fulltext", "fulltext" + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTINDEXED);
            }
            this.addPropertyInfo(null, FULLTEXT_SIMPLETEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_SIMPLETEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
            this.addPropertyInfo(null, FULLTEXT_BINARYTEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_BINARYTEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
        }
    }

    public String getFulltextIndexSuffix(String indexName) {
        return indexName.equals(FULLTEXT_DEFAULT_INDEX) ? "" : '_' + indexName;
    }

    private void initAclModel() {
        LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
        keysType.put("pos", ColumnType.INTEGER);
        keysType.put("name", ColumnType.SYSNAME);
        keysType.put(ACL_GRANT_KEY, ColumnType.BOOLEAN);
        keysType.put(ACL_PERMISSION_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_USER_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_GROUP_KEY, ColumnType.SYSNAME);
        String fragmentName = ACL_TABLE_NAME;
        this.addCollectionFragmentInfos(fragmentName, PropertyType.COLL_ACL, "pos", keysType);
        this.addPropertyInfo(null, ACL_PROP, PropertyType.COLL_ACL, fragmentName, null, false, null, null);
    }

    private String initTypeModel(ComplexType complexType) throws StorageException {
        String typeName = complexType.getName();
        if (this.schemaFragment.containsKey(typeName)) {
            return this.schemaFragment.get(typeName);
        }
        log.debug((Object)("Making model for type " + typeName));
        String thisFragmentName = null;
        for (Field field : complexType.getFields()) {
            String fragmentKey;
            String subFragmentName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                ComplexType fieldComplexType = (ComplexType)fieldType;
                String subTypeName = fieldComplexType.getName();
                subFragmentName = this.initTypeModel(fieldComplexType);
                this.addTypeFragment(subTypeName, subFragmentName);
                continue;
            }
            String propertyName = field.getName().getPrefixedName();
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (listFieldType.isSimpleType()) {
                    String fragmentName = this.collectionFragmentName(propertyName);
                    PropertyType propertyType = PropertyType.fromFieldType(listFieldType, true);
                    ColumnType type = ColumnType.fromFieldType(listFieldType);
                    if (type.spec == ColumnSpec.STRING) {
                        for (RepositoryDescriptor.FieldDescriptor fd : this.repositoryDescriptor.schemaFields) {
                            if (!propertyName.equals(fd.field) || !FIELD_TYPE_LARGETEXT.equals(fd.type)) continue;
                            type = ColumnType.CLOB;
                            break;
                        }
                        log.debug((Object)("  String array field '" + propertyName + "' using column type " + type));
                    }
                    this.addPropertyInfo(typeName, propertyName, propertyType, fragmentName, COLL_TABLE_VALUE_KEY, false, null, type);
                    LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
                    keysType.put("pos", ColumnType.INTEGER);
                    keysType.put(COLL_TABLE_VALUE_KEY, type);
                    this.addCollectionFragmentInfos(fragmentName, propertyType, "pos", keysType);
                    this.addTypeCollectionFragment(typeName, fragmentName);
                    this.addFieldFragment(field, fragmentName);
                    continue;
                }
                subFragmentName = this.initTypeModel((ComplexType)listFieldType);
                this.addTypeFragment(listFieldType.getName(), subFragmentName);
                continue;
            }
            String fragmentName = Model.typeFragmentName(complexType);
            PropertyType propertyType = PropertyType.fromFieldType(fieldType, false);
            ColumnType type = ColumnType.fromField(field);
            if (type.spec == ColumnSpec.STRING) {
                for (RepositoryDescriptor.FieldDescriptor fd : this.repositoryDescriptor.schemaFields) {
                    if (!propertyName.equals(fd.field) || !FIELD_TYPE_LARGETEXT.equals(fd.type)) continue;
                    if (!type.isUnconstrained() && !type.isClob()) {
                        log.warn((Object)("  String field '" + propertyName + "' has a schema constraint to " + type + " but is specified as largetext," + " using CLOB for it"));
                    }
                    type = ColumnType.CLOB;
                    break;
                }
            }
            if ("id".equalsIgnoreCase(fragmentKey = field.getName().getLocalName())) {
                String msg = "A property cannot be named '" + fragmentKey + "' because this is a reserved name, in type: " + typeName;
                throw new StorageException(msg);
            }
            if (fragmentName.equals(UID_SCHEMA_NAME) && (fragmentKey.equals(UID_MAJOR_VERSION_KEY) || fragmentKey.equals(UID_MINOR_VERSION_KEY))) {
                fragmentKey = fragmentKey.equals(UID_MAJOR_VERSION_KEY) ? MAIN_MAJOR_VERSION_KEY : MAIN_MINOR_VERSION_KEY;
                this.addPropertyInfo(typeName, propertyName, propertyType, HIER_TABLE_NAME, fragmentKey, false, null, type);
            } else {
                this.addPropertyInfo(typeName, propertyName, propertyType, fragmentName, fragmentKey, false, null, type);
                thisFragmentName = fragmentName;
            }
            this.addFieldFragment(field, fragmentName);
        }
        this.schemaFragment.put(typeName, thisFragmentName);
        return thisFragmentName;
    }

    private static String typeFragmentName(ComplexType type) {
        return type.getName();
    }

    private String collectionFragmentName(String propertyName) {
        return propertyName;
    }
}

