/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.catalog;

import java.util.HashMap;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

public class GetCatalog
implements ContextOperation {
    private static final long serialVersionUID = -6657995003127926278L;
    private static final String ENTRY = "apacheCatalogEntry";
    private static final String ENTRY_NAME = "apacheCatalogEntryName";
    private static final String ENTRY_BASEDN = "apacheCatalogEntryBaseDn";

    public Object execute(DirContext ctx, Name base) throws Exception {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String filter = "(objectClass=apacheCatalogEntry)";
        NamingEnumeration<SearchResult> list = ctx.search("", filter, controls);
        HashMap<String, String> catalog = new HashMap<String, String>();
        while (list.hasMore()) {
            SearchResult result = list.next();
            Attributes attrs = result.getAttributes();
            Attribute attr = attrs.get(ENTRY_NAME);
            String name = attr != null ? (String)attr.get() : null;
            attr = attrs.get(ENTRY_BASEDN);
            String basedn = attr != null ? (String)attr.get() : null;
            catalog.put(name, basedn);
        }
        return catalog;
    }
}

