/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.java2d.RotateQuadrantJ2DOp;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.RotateOp;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateJ2DOp
extends OperationImplementation<RotateOp, BufferedImage> {
    private static final String CLASS = RotateQuadrantJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected BufferedImage execute(RotateOp operation, BufferedImage bufferedImage) {
        double degrees = operation.getDegrees();
        Quality quality = operation.getQuality();
        logger.fine("rotate(" + degrees + ", " + (Object)((Object)quality) + ")");
        Java2DUtils.logImage(logger, ">>>> source bufferedImage", bufferedImage);
        BufferedImage result = bufferedImage;
        if (degrees != 0.0) {
            result = Java2DUtils.rotateWithDrawImage(bufferedImage, degrees, quality);
        }
        Java2DUtils.logImage(logger, ">>>> rotate() returning ", result);
        return result;
    }
}

