/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dam.core.service.InheritedPropertiesService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class InitPropertiesListener
implements EventListener {
    private static final Log log = LogFactory.getLog(InitPropertiesListener.class);
    protected InheritedPropertiesService inheritedPropertiesService;

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            CoreSession coreSession = docCtx.getCoreSession();
            if (doc.hasFacet("Asset") && !"ImportSet".equals(doc.getType())) {
                DocumentModel importSet = this.getImportSet(coreSession, doc);
                if (importSet == null || "/".equals(importSet.getPathAsString())) {
                    return;
                }
                InheritedPropertiesService service = this.getInheritedPropertiesService();
                if (service != null) {
                    service.inheritProperties(importSet, doc);
                }
            }
        }
    }

    protected DocumentModel getImportSet(CoreSession session, DocumentModel doc) throws ClientException {
        if ("ImportSet".equals(doc.getType())) {
            return doc;
        }
        DocumentModel parent = this.getFirstAccessibleParent(session, doc);
        if (parent == null || "/".equals(parent.getPathAsString())) {
            return null;
        }
        return this.getImportSet(session, parent);
    }

    protected DocumentModel getFirstAccessibleParent(CoreSession session, DocumentModel doc) throws ClientException {
        AccessibleParentFinder finder = new AccessibleParentFinder(session, doc);
        finder.runUnrestricted();
        return finder.parentRef != null ? session.getDocument(finder.parentRef) : null;
    }

    protected InheritedPropertiesService getInheritedPropertiesService() {
        if (this.inheritedPropertiesService == null) {
            try {
                this.inheritedPropertiesService = (InheritedPropertiesService)Framework.getService(InheritedPropertiesService.class);
            }
            catch (Exception e) {
                log.error((Object)"Unable to retrieve InheritedPropertiesService", (Throwable)e);
            }
        }
        return this.inheritedPropertiesService;
    }

    protected static class AccessibleParentFinder
    extends UnrestrictedSessionRunner {
        protected final CoreSession userSession;
        public final DocumentModel doc;
        public DocumentRef parentRef;

        public AccessibleParentFinder(CoreSession session, DocumentModel doc) {
            super(session);
            this.userSession = session;
            this.doc = doc;
        }

        public void run() throws ClientException {
            this.parentRef = this.getFirstParentAccessibleByUser(this.doc);
        }

        protected DocumentRef getFirstParentAccessibleByUser(DocumentModel doc) throws ClientException {
            DocumentModel parent = this.session.getDocument(doc.getParentRef());
            if (parent == null || "/".equals(parent.getPathAsString())) {
                return null;
            }
            if (this.userSession.hasPermission(parent.getRef(), "Read")) {
                return parent.getRef();
            }
            return this.getFirstParentAccessibleByUser(parent);
        }
    }
}

