/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.events.DocumentAttributeFilterFactory;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventContext;

@XObject(value="handler")
public class EventHandler {
    @XNode(value="@chainId")
    protected String chainId;
    @XNode(value="@postCommit")
    protected boolean isPostCommit;
    @XNodeList(value="event", type=HashSet.class, componentType=String.class)
    protected Set<String> events;
    @XNodeList(value="filters/doctype", type=HashSet.class, componentType=String.class, nullByDefault=true)
    protected Set<String> doctypes;
    @XNode(value="filters/facet")
    protected String facet;
    protected String[] lifeCycle;
    @XNode(value="filters/pathStartsWith")
    protected String pathStartsWith;
    protected Filter attribute;
    @XNodeList(value="filters/group", type=ArrayList.class, componentType=String.class)
    protected List<String> memberOf;
    @XNode(value="filters/isAdministrator")
    protected Boolean isAdministrator;
    protected String expression;
    private Expression expr;

    @XNode(value="filters/lifeCycle")
    protected void setLifeCycleExpr(String lifeCycles) {
        this.lifeCycle = StringUtils.split((String)lifeCycles, (char)',', (boolean)true);
    }

    @XNode(value="filters/attribute")
    public void setAttribute(String attribute) {
        this.attribute = DocumentAttributeFilterFactory.getFilter(attribute);
    }

    @XNode(value="filters/expression")
    protected void _setExpression(String expr) {
        expr = expr.replaceAll("&amp;", "&");
        expr = expr.replaceAll("&lt;", "<");
        this.expression = expr.replaceAll("&gt;", ">");
    }

    public EventHandler() {
    }

    public EventHandler(String eventId, String chainId) {
        this(Collections.singleton(eventId), chainId);
    }

    public EventHandler(Set<String> eventId, String chainId) {
        this.events = eventId;
        this.chainId = chainId;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setPostCommit(boolean isPostCommit) {
        this.isPostCommit = isPostCommit;
    }

    public boolean isPostCommit() {
        return this.isPostCommit;
    }

    public void setAttributeFilter(Filter attribute) {
        this.attribute = attribute;
    }

    public void setIsAdministrator(Boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
    }

    public void setMemberOf(List<String> groups) {
        this.memberOf = groups;
    }

    public void setPathStartsWith(String pathStartsWith) {
        this.pathStartsWith = pathStartsWith;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setDoctypes(Set<String> doctypes) {
        this.doctypes = doctypes;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public void setLifeCycle(String[] lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getFacet() {
        return this.facet;
    }

    public Filter getAttribute() {
        return this.attribute;
    }

    public String[] getLifeCycle() {
        return this.lifeCycle;
    }

    public List<String> getMemberOf() {
        return this.memberOf;
    }

    public Boolean getIsAdministrator() {
        return this.isAdministrator;
    }

    public String getPathStartsWith() {
        return this.pathStartsWith;
    }

    public Set<String> getDoctypes() {
        return this.doctypes;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public boolean isEnabled(OperationContext ctx, EventContext eventCtx, boolean quick) throws Exception {
        Object obj = ctx.getInput();
        DocumentModel doc = null;
        if (obj instanceof DocumentModel) {
            doc = (DocumentModel)obj;
        }
        if (this.doctypes != null && (doc == null || !this.doctypes.isEmpty() && !this.doctypes.contains(doc.getType()))) {
            return false;
        }
        if (!(this.facet == null || doc != null && doc.hasFacet(this.facet))) {
            return false;
        }
        if (this.lifeCycle != null && this.lifeCycle.length > 0) {
            if (doc == null) {
                return false;
            }
            boolean match = false;
            String currentLc = doc.getCurrentLifeCycleState();
            for (String lc : this.lifeCycle) {
                if (!lc.equals(currentLc)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (!(this.attribute == null || doc != null && this.attribute.accept(doc))) {
            return false;
        }
        if (!(this.pathStartsWith == null || doc != null && doc.getPathAsString().startsWith(this.pathStartsWith))) {
            return false;
        }
        if (this.memberOf != null && !this.memberOf.isEmpty()) {
            NuxeoPrincipal p = (NuxeoPrincipal)eventCtx.getPrincipal();
            boolean granted = false;
            for (String group : this.memberOf) {
                if (!p.isMemberOf(group)) continue;
                granted = true;
                break;
            }
            if (!granted) {
                return false;
            }
        }
        if (this.isAdministrator != null && !((NuxeoPrincipal)eventCtx.getPrincipal()).isAdministrator()) {
            return false;
        }
        if (quick) {
            return true;
        }
        if (this.expression != null) {
            if (this.expr == null) {
                this.expr = Scripting.newExpression(this.expression);
            }
            if (((Boolean)this.expr.eval(ctx)).booleanValue()) {
                return false;
            }
        }
        return true;
    }
}

