/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloader;

@Name(value="seamReloadContext")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class NuxeoSeamHotReloadContextKeeper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoSeamHotReloader.class);
    protected Long lastCacheKey;
    @In(create=true)
    protected NuxeoSeamHotReloader seamReload;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReloadIdNeeded() {
        if (this.lastCacheKey == null) {
            this.doLog("No last cache key => no hot reload triggered");
            this.lastCacheKey = System.currentTimeMillis();
        } else if (this.seamReload.shouldResetCache(this.lastCacheKey)) {
            this.doLog(String.format("Before reset, cache key=%s", this.lastCacheKey));
            try {
                Events.instance().raiseEvent("flush", new Object[0]);
            }
            finally {
                Long currentTimestamp = this.seamReload.getCurrentCacheTimestamp();
                if (currentTimestamp != null) {
                    this.lastCacheKey = this.seamReload.getCurrentCacheTimestamp();
                }
            }
            this.doLog(String.format("After reset, cache key=%s", this.lastCacheKey));
        } else {
            this.doLog(String.format("No reset needed, cache key=%s", this.lastCacheKey));
        }
    }

    protected void doLog(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }
}

