/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import com.noelios.restlet.ext.servlet.ServletConverter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.restAPI.SeamRestletFilter;
import org.nuxeo.ecm.platform.ui.web.restAPI.ThreadSafeRestletFilter;
import org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService;
import org.nuxeo.ecm.platform.ui.web.restAPI.service.RestletPluginDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;

public class RestletServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(RestletServlet.class);
    private static final long serialVersionUID = 1764653653643L;
    protected ServletConverter converter;
    protected PluggableRestletService service;

    public synchronized void init() throws ServletException {
        super.init();
        if (this.converter != null) {
            log.error((Object)"RestletServlet initialized several times");
            return;
        }
        this.converter = new ServletConverter(this.getServletContext());
        Router restletRouter = new Router();
        this.service = (PluggableRestletService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService"));
        if (this.service == null) {
            log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService");
            throw new ServletException("Can't initialize Nuxeo Pluggable Restlet Service");
        }
        for (String restletName : this.service.getContributedRestletNames()) {
            Object restletToAdd;
            RestletPluginDescriptor plugin = this.service.getContributedRestletDescriptor(restletName);
            if (plugin.getUseSeam()) {
                SeamRestletFilter seamFilter = new SeamRestletFilter(plugin.getUseConversation());
                Restlet seamRestlet = this.service.getContributedRestletByName(restletName);
                seamFilter.setNext(seamRestlet);
                restletToAdd = seamFilter;
            } else if (plugin.isSingleton()) {
                restletToAdd = this.service.getContributedRestletByName(restletName);
            } else {
                ThreadSafeRestletFilter threadSafeRestletFilter = new ThreadSafeRestletFilter();
                Restlet restlet = this.service.getContributedRestletByName(restletName);
                threadSafeRestletFilter.setNext(restlet);
                restletToAdd = threadSafeRestletFilter;
            }
            for (String urlPattern : plugin.getUrlPatterns()) {
                log.debug((Object)("Pre-compiling restlet pattern " + urlPattern));
                Route route = restletRouter.attach(urlPattern, restletToAdd);
                route.getTemplate().match("");
            }
        }
        this.converter.setTarget((Restlet)restletRouter);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean tx = false;
        if (!TransactionHelper.isTransactionActive()) {
            tx = TransactionHelper.startTransaction();
        }
        try {
            this.converter.service(req, res);
        }
        catch (ServletException e) {
            if (tx) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            throw e;
        }
        catch (IOException e) {
            if (tx) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            throw e;
        }
        finally {
            if (tx && TransactionHelper.isTransactionActive()) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }
}

