/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.net.ConnectException;
import org.artofsolving.jodconverter.office.OfficeConnection;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.artofsolving.jodconverter.office.UnoUrl;

class ExternalOfficeManager
implements OfficeManager {
    private final OfficeConnection connection;
    private final boolean connectOnStart;

    public ExternalOfficeManager(UnoUrl unoUrl, boolean connectOnStart) {
        this.connection = new OfficeConnection(unoUrl);
        this.connectOnStart = connectOnStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OfficeException {
        if (this.connectOnStart) {
            OfficeConnection officeConnection = this.connection;
            synchronized (officeConnection) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (this.connection.isConnected()) {
                this.connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeTask task) throws OfficeException {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (!this.connection.isConnected()) {
                this.connect();
            }
            task.execute(this.connection);
        }
    }

    private void connect() {
        try {
            this.connection.connect();
        }
        catch (ConnectException connectException) {
            throw new OfficeException("could not connect to external office process", connectException);
        }
    }

    public OfficeConnection[] getConnection() {
        OfficeConnection[] result = new OfficeConnection[]{this.connection};
        return result;
    }
}

