/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.jsf.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.runtime.api.Framework;

@Name(value="collectionBulkEditActions")
@Scope(value=org.jboss.seam.ScopeType.CONVERSATION)
@Install(precedence=10)
public class CollectionBulkEditActions
implements Serializable {
    public static final String SELECTION_EDITED = "selectionEdited";
    public static final String DOCUMENTS_IMPORTED = "documentImported";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    @Observer(value={"selectionEdited", "documentImported"})
    public void addCollectionsOnEvent(List<DocumentModel> documents, DocumentModel doc) throws ClientException {
        List collectionIds = (List)((Object)doc.getContextData(ScopeType.REQUEST, "bulk_collections"));
        if (collectionIds != null && !collectionIds.isEmpty()) {
            ArrayList<DocumentModel> collections = new ArrayList<DocumentModel>();
            for (String collectionId : collectionIds) {
                IdRef idRef = new IdRef(collectionId);
                if (!this.documentManager.exists((DocumentRef)idRef)) continue;
                collections.add(this.documentManager.getDocument((DocumentRef)idRef));
            }
            CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
            for (DocumentModel collection : collections) {
                if (!collectionManager.canAddToCollection(collection, this.documentManager)) continue;
                collectionManager.addToCollection(collection, documents, this.documentManager);
            }
        }
    }
}

