/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.shared.BrokenException;
import java.util.HashSet;
import java.util.Iterator;

public class QueryTriple {
    public final QueryNode S;
    public final QueryNode P;
    public final QueryNode O;

    public QueryTriple(QueryNode S, QueryNode P, QueryNode O) {
        this.S = S;
        this.P = P;
        this.O = O;
    }

    public String toString() {
        return "<qt " + this.S.toString() + " " + this.P.toString() + " " + this.O.toString() + ">";
    }

    public static QueryTriple[] classify(QueryNodeFactory f, Mapping m, Triple[] t) {
        QueryTriple[] result = f.createArray(t.length);
        for (int i = 0; i < t.length; ++i) {
            result[i] = QueryTriple.classify(f, m, t[i]);
        }
        return result;
    }

    public static QueryTriple classify(QueryNodeFactory f, Mapping m, Triple t) {
        HashSet<Node> fresh = new HashSet<Node>();
        return f.createTriple(QueryNode.classify(f, m, fresh, t.getSubject()), QueryNode.classify(f, m, fresh, t.getPredicate()), QueryNode.classify(f, m, fresh, t.getObject()));
    }

    public Applyer createApplyer(Graph g) {
        return new SimpleApplyer(g, this);
    }

    public Matcher createMatcher() {
        int SMATCH = 4;
        int PMATCH = 2;
        boolean OMATCH = true;
        boolean NOMATCH = false;
        int bits = (this.S.mustMatch() ? 4 : 0) + (this.P.mustMatch() ? 2 : 0) + (this.O.mustMatch() ? 1 : 0);
        switch (bits) {
            case 7: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.S.match(d, t.getSubject()) && QueryTriple.this.P.match(d, t.getPredicate()) && QueryTriple.this.O.match(d, t.getObject());
                    }
                };
            }
            case 5: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.S.match(d, t.getSubject()) && QueryTriple.this.O.match(d, t.getObject());
                    }
                };
            }
            case 6: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.S.match(d, t.getSubject()) && QueryTriple.this.P.match(d, t.getPredicate());
                    }
                };
            }
            case 3: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.P.match(d, t.getPredicate()) && QueryTriple.this.O.match(d, t.getObject());
                    }
                };
            }
            case 4: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.S.match(d, t.getSubject());
                    }
                };
            }
            case 2: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.P.match(d, t.getPredicate());
                    }
                };
            }
            case 1: {
                return new Matcher(){

                    public boolean match(Domain d, Triple t) {
                        return QueryTriple.this.O.match(d, t.getObject());
                    }
                };
            }
            case 0: {
                return Matcher.always;
            }
        }
        throw new BrokenException("uncatered-for case in optimisation");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleApplyer
    extends Applyer {
        protected final Graph g;
        protected final QueryNode s;
        protected final QueryNode p;
        protected final QueryNode o;

        protected SimpleApplyer(Graph g, QueryTriple qt) {
            this.g = g;
            this.o = qt.O;
            this.p = qt.P;
            this.s = qt.S;
        }

        public Iterator<Triple> find(Domain d) {
            return this.g.find(this.s.finder(d), this.p.finder(d), this.o.finder(d));
        }

        @Override
        public void applyToTriples(Domain d, Matcher m, StageElement next) {
            Iterator<Triple> it = this.find(d);
            while (it.hasNext()) {
                if (!m.match(d, it.next())) continue;
                next.run(d);
            }
        }
    }
}

