/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="GetLiveDocument", category="Document", label="Get Live Document", description="Get the live document even if this is a Proxy or Version Document.")
public class GetLiveDocument {
    public static final String ID = "GetLiveDocument";
    private static int MAX_ITERATION = 5;
    @Context
    protected CoreSession session;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) throws ClientException {
        DocumentModel doc = this.session.getSourceDocument(input.getRef());
        for (int i = 0; i < MAX_ITERATION && !this.isLive(doc); ++i) {
            doc = this.session.getSourceDocument(doc.getRef());
        }
        return doc;
    }

    private boolean isLive(DocumentModel doc) {
        return !doc.isVersion() && !doc.isProxy();
    }
}

