/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotInfo;

public class CreateSnapshotResponse
extends ActionResponse
implements ToXContent {
    @Nullable
    private SnapshotInfo snapshotInfo;

    CreateSnapshotResponse(@Nullable SnapshotInfo snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
    }

    CreateSnapshotResponse() {
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.snapshotInfo = SnapshotInfo.readOptionalSnapshotInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable(this.snapshotInfo);
    }

    public RestStatus status() {
        if (this.snapshotInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.snapshotInfo.status();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.snapshotInfo != null) {
            builder.field(Fields.SNAPSHOT);
            this.snapshotInfo.toXContent(builder, params);
        } else {
            builder.field(Fields.ACCEPTED, true);
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
        static final XContentBuilderString ACCEPTED = new XContentBuilderString("accepted");

        Fields() {
        }
    }
}

