/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.dynamic;

import java.util.LinkedList;
import org.elasticsearch.common.mvel2.optimizers.dynamic.DynamicAccessor;
import org.elasticsearch.common.mvel2.util.MVELClassLoader;

public class DynamicClassLoader
extends ClassLoader
implements MVELClassLoader {
    private int totalClasses;
    private int tenureLimit;
    private final LinkedList<DynamicAccessor> allAccessors = new LinkedList();

    public DynamicClassLoader(ClassLoader classLoader, int tenureLimit) {
        super(classLoader);
        this.tenureLimit = tenureLimit;
    }

    public Class defineClassX(String className, byte[] b, int start, int end) {
        ++this.totalClasses;
        return super.defineClass(className, b, start, end);
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicAccessor registerDynamicAccessor(DynamicAccessor accessor) {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            this.allAccessors.add(accessor);
            while (this.allAccessors.size() > this.tenureLimit) {
                DynamicAccessor da = this.allAccessors.removeFirst();
                if (da == null) continue;
                da.deoptimize();
            }
            assert (accessor != null);
            return accessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deoptimizeAll() {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            for (DynamicAccessor a : this.allAccessors) {
                if (a == null) continue;
                a.deoptimize();
            }
            this.allAccessors.clear();
        }
    }

    public boolean isOverloaded() {
        return this.tenureLimit < this.totalClasses;
    }
}

