/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStats;

public interface Translog
extends IndexShardComponent,
CloseableIndexComponent {
    public static final ByteSizeValue INACTIVE_SHARD_TRANSLOG_BUFFER = ByteSizeValue.parseBytesSizeValue("1kb");
    public static final String TRANSLOG_ID_KEY = "translog_id";

    public void updateBuffer(ByteSizeValue var1);

    public void closeWithDelete();

    public long currentId();

    public int estimatedNumberOfOperations();

    public long memorySizeInBytes();

    public long translogSizeInBytes();

    public void newTranslog(long var1) throws TranslogException;

    public void newTransientTranslog(long var1) throws TranslogException;

    public void makeTransientCurrent();

    public void revertTransient();

    public Location add(Operation var1) throws TranslogException;

    public byte[] read(Location var1);

    public Snapshot snapshot() throws TranslogException;

    public Snapshot snapshot(Snapshot var1);

    public void clearUnreferenced();

    public void sync();

    public boolean syncNeeded();

    public void syncOnEachOperation(boolean var1);

    public TranslogStats stats();

    public static class DeleteByQuery
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 2;
        private BytesReference source;
        @Nullable
        private String[] filteringAliases;
        private String[] types = Strings.EMPTY_ARRAY;

        public DeleteByQuery() {
        }

        public DeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
            this(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types());
        }

        public DeleteByQuery(BytesReference source, String[] filteringAliases, String ... types) {
            this.source = source;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.filteringAliases = filteringAliases;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE_BY_QUERY;
        }

        @Override
        public long estimateSize() {
            return this.source.length() + 8;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public String[] types() {
            return this.types;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            throw new ElasticsearchIllegalStateException("trying to read doc source from delete_by_query operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int aliasesSize;
            int typesSize;
            int version = in.readVInt();
            this.source = in.readBytesReference();
            if (version < 2 && in.readBoolean()) {
                in.readString();
            }
            if ((typesSize = in.readVInt()) > 0) {
                this.types = new String[typesSize];
                for (int i = 0; i < typesSize; ++i) {
                    this.types[i] = in.readString();
                }
            }
            if (version >= 1 && (aliasesSize = in.readVInt()) > 0) {
                this.filteringAliases = new String[aliasesSize];
                for (int i = 0; i < aliasesSize; ++i) {
                    this.filteringAliases[i] = in.readString();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeBytesReference(this.source);
            out.writeVInt(this.types.length);
            for (String type : this.types) {
                out.writeString(type);
            }
            if (this.filteringAliases != null) {
                out.writeVInt(this.filteringAliases.length);
                for (String alias : this.filteringAliases) {
                    out.writeString(alias);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class Delete
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 2;
        private Term uid;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;

        public Delete() {
        }

        public Delete(Engine.Delete delete) {
            this(delete.uid());
            this.version = delete.version();
            this.versionType = delete.versionType();
        }

        public Delete(Term uid) {
            this.uid = uid;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            throw new ElasticsearchIllegalStateException("trying to read doc source from delete operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.uid = new Term(in.readString(), in.readString());
            if (version >= 1) {
                this.version = in.readLong();
            }
            if (version >= 2) {
                this.versionType = VersionType.fromValue(in.readByte());
            }
            assert (this.versionType.validateVersion(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeString(this.uid.field());
            out.writeString(this.uid.text());
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
        }
    }

    public static class Index
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 6;
        private String id;
        private String type;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;

        public Index() {
        }

        public Index(Engine.Index index) {
            this.id = index.id();
            this.type = index.type();
            this.source = index.source();
            this.routing = index.routing();
            this.parent = index.parent();
            this.version = index.version();
            this.timestamp = index.timestamp();
            this.ttl = index.ttl();
            this.versionType = index.versionType();
        }

        public Index(String type, String id, byte[] source) {
            this.type = type;
            this.id = id;
            this.source = new BytesArray(source);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.SAVE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public BytesReference source() {
            return this.source;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            this.readFrom(in);
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readString();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readString();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
            if (version >= 4) {
                this.timestamp = in.readLong();
            }
            if (version >= 5) {
                this.ttl = in.readLong();
            }
            if (version >= 6) {
                this.versionType = VersionType.fromValue(in.readByte());
            }
            assert (this.versionType.validateVersion(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(6);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
            out.writeByte(this.versionType.getValue());
        }
    }

    public static class Create
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 6;
        private String id;
        private String type;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;

        public Create() {
        }

        public Create(Engine.Create create) {
            this.id = create.id();
            this.type = create.type();
            this.source = create.source();
            this.routing = create.routing();
            this.parent = create.parent();
            this.timestamp = create.timestamp();
            this.ttl = create.ttl();
            this.version = create.version();
            this.versionType = create.versionType();
        }

        public Create(String type, String id, byte[] source) {
            this.id = id;
            this.type = type;
            this.source = new BytesArray(source);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String id() {
            return this.id;
        }

        public BytesReference source() {
            return this.source;
        }

        public String type() {
            return this.type;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            this.readFrom(in);
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readString();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readString();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
            if (version >= 4) {
                this.timestamp = in.readLong();
            }
            if (version >= 5) {
                this.ttl = in.readLong();
            }
            if (version >= 6) {
                this.versionType = VersionType.fromValue(in.readByte());
            }
            assert (this.versionType.validateVersion(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(6);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
            out.writeByte(this.versionType.getValue());
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;
        public final String parent;
        public final long timestamp;
        public final long ttl;

        public Source(BytesReference source, String routing, String parent, long timestamp, long ttl) {
            this.source = source;
            this.routing = routing;
            this.parent = parent;
            this.timestamp = timestamp;
            this.ttl = ttl;
        }
    }

    public static interface Operation
    extends Streamable {
        public Type opType();

        public long estimateSize();

        public Source readSource(StreamInput var1) throws IOException;

        public static enum Type {
            CREATE(1),
            SAVE(2),
            DELETE(3),
            DELETE_BY_QUERY(4);

            private final byte id;

            private Type(byte id) {
                this.id = id;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id) {
                switch (id) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return SAVE;
                    }
                    case 3: {
                        return DELETE;
                    }
                    case 4: {
                        return DELETE_BY_QUERY;
                    }
                }
                throw new IllegalArgumentException("No type mapped for [" + id + "]");
            }
        }
    }

    public static interface Snapshot
    extends Releasable {
        public long translogId();

        public long position();

        public long length();

        public int estimatedTotalOperations();

        public boolean hasNext();

        public Operation next();

        public void seekForward(long var1);

        public InputStream stream() throws IOException;

        public long lengthInBytes();
    }

    public static class Location {
        public final long translogId;
        public final long translogLocation;
        public final int size;

        public Location(long translogId, long translogLocation, int size) {
            this.translogId = translogId;
            this.translogLocation = translogLocation;
            this.size = size;
        }
    }
}

