/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.primitives.Longs;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.RedBlackTree;

public class GroupRedBlackTree
extends RedBlackTree {
    private long nextId = 1L;
    private double[] centroids;
    private long[] counts;
    private int[] aggregatedSizes;
    private long[] aggregatedCounts;
    private long[] ids;
    double tmpCentroid;
    long tmpCount;
    long tmpId;

    public GroupRedBlackTree(int capacity) {
        super(capacity);
        this.centroids = new double[1 + capacity];
        this.aggregatedSizes = new int[1 + capacity];
        this.counts = new long[1 + capacity];
        this.aggregatedCounts = new long[1 + capacity];
        this.ids = new long[1 + capacity];
    }

    @Override
    protected int compare(int node) {
        double centroid = this.mean(node);
        int cmp = Double.compare(this.tmpCentroid, centroid);
        if (cmp == 0) {
            cmp = Longs.compare(this.tmpId, this.ids[node]);
        }
        return cmp;
    }

    @Override
    protected void copy(int node) {
        this.centroids[node] = this.tmpCentroid;
        this.counts[node] = this.tmpCount;
        this.ids[node] = this.tmpId;
    }

    @Override
    protected void merge(int node) {
        throw new IllegalStateException("compare should never return 0");
    }

    @Override
    protected void swap(int node1, int node2) {
        super.swap(node1, node2);
        int n = node1;
        while (n != 0) {
            this.fixAggregates(n);
            n = this.parent(n);
        }
    }

    @Override
    protected int newNode() {
        int newNode = super.newNode();
        if (newNode >= this.centroids.length) {
            int minSize = ArrayUtil.oversize((int)(newNode + 1), (int)4);
            this.centroids = Arrays.copyOf(this.centroids, minSize);
            this.counts = Arrays.copyOf(this.counts, minSize);
            this.aggregatedSizes = Arrays.copyOf(this.aggregatedSizes, minSize);
            this.aggregatedCounts = Arrays.copyOf(this.aggregatedCounts, minSize);
            this.ids = Arrays.copyOf(this.ids, minSize);
        }
        return newNode;
    }

    private void fixAggregates(int node) {
        int left = this.left(node);
        int right = this.right(node);
        this.aggregatedCounts[node] = this.counts[node] + this.aggregatedCounts[left] + this.aggregatedCounts[right];
        this.aggregatedSizes[node] = 1 + this.aggregatedSizes[left] + this.aggregatedSizes[right];
    }

    private void fixCounts(int node) {
        int left = this.left(node);
        int right = this.right(node);
        this.aggregatedCounts[node] = this.counts[node] + this.aggregatedCounts[left] + this.aggregatedCounts[right];
    }

    @Override
    protected void rotateLeft(int node) {
        super.rotateLeft(node);
        this.fixAggregates(node);
        this.fixAggregates(this.parent(node));
    }

    @Override
    protected void rotateRight(int node) {
        super.rotateRight(node);
        this.fixAggregates(node);
        this.fixAggregates(this.parent(node));
    }

    @Override
    protected void beforeRemoval(int node) {
        long count = this.count(node);
        int n = node;
        while (n != 0) {
            int n2 = n;
            this.aggregatedCounts[n2] = this.aggregatedCounts[n2] - count;
            int n3 = n;
            this.aggregatedSizes[n3] = this.aggregatedSizes[n3] - 1;
            n = this.parent(n);
        }
        super.beforeRemoval(node);
    }

    @Override
    protected void afterInsertion(int node) {
        long count;
        this.aggregatedCounts[node] = count = this.count(node);
        this.aggregatedSizes[node] = 1;
        int n = node;
        int p = this.parent(node);
        while (p != 0) {
            int n2 = p;
            this.aggregatedCounts[n2] = this.aggregatedCounts[n2] + count;
            int n3 = p;
            this.aggregatedSizes[n3] = this.aggregatedSizes[n3] + 1;
            n = p;
            p = this.parent(n);
        }
        super.afterInsertion(node);
    }

    public double mean(int node) {
        return this.centroids[node];
    }

    public long count(int node) {
        return this.counts[node];
    }

    public long id(int node) {
        return this.ids[node];
    }

    public void addGroup(double centroid, long count, long id) {
        this.tmpCentroid = centroid;
        this.tmpCount = count;
        this.tmpId = id;
        if (id >= this.nextId) {
            this.nextId = id + 1L;
        }
        this.addNode();
    }

    public void addGroup(double centroid, long count) {
        this.addGroup(centroid, count, this.nextId++);
    }

    public boolean removeGroup(double centroid, int id) {
        this.tmpCentroid = centroid;
        this.tmpId = id;
        int nodeToRemove = this.getNode();
        if (nodeToRemove != 0) {
            this.removeNode(nodeToRemove);
            return true;
        }
        return false;
    }

    public void updateGroup(int node, double centroid, long count) {
        this.tmpCentroid = centroid;
        this.tmpId = this.id(node);
        this.tmpCount = count;
        int prev = this.prevNode(node);
        int next = this.nextNode(node);
        if (!(prev != 0 && this.compare(prev) <= 0 || next != 0 && this.compare(next) >= 0)) {
            this.copy(node);
            int n = node;
            while (n != 0) {
                this.fixCounts(n);
                n = this.parent(n);
            }
        } else {
            this.removeNode(node);
            this.addNode();
        }
    }

    public int floorNode(double centroid) {
        int floor = 0;
        int node = this.root();
        while (node != 0) {
            int cmp = Double.compare(centroid, this.mean(node));
            if (cmp <= 0) {
                node = this.left(node);
                continue;
            }
            floor = node;
            node = this.right(node);
        }
        return floor;
    }

    public int ceilingNode(double centroid) {
        int ceiling = 0;
        int node = this.root();
        while (node != 0) {
            int cmp = Double.compare(this.mean(node), centroid);
            if (cmp < 0) {
                node = this.right(node);
                continue;
            }
            ceiling = node;
            node = this.left(node);
        }
        return ceiling;
    }

    public void headSum(int node, SizeAndSum sizeAndSum) {
        if (node == 0) {
            sizeAndSum.size = 0;
            sizeAndSum.sum = 0L;
            return;
        }
        int left = this.left(node);
        sizeAndSum.size = this.aggregatedSizes[left];
        sizeAndSum.sum = this.aggregatedCounts[left];
        int n = node;
        int p = this.parent(node);
        while (p != 0) {
            if (n == this.right(p)) {
                int leftP = this.left(p);
                sizeAndSum.size += 1 + this.aggregatedSizes[leftP];
                sizeAndSum.sum += this.counts[p] + this.aggregatedCounts[leftP];
            }
            n = p;
            p = this.parent(n);
        }
    }

    public static class SizeAndSum {
        public int size;
        public long sum;
    }
}

