/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters.io;

import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharIterator;

public class ReaderCharIterator
implements CharIterator {
    private final Reader m_aReader;
    private boolean m_bNextAvailable = false;
    private int m_nNext;

    public ReaderCharIterator(@Nonnull Reader reader) {
        this.m_aReader = reader;
    }

    @Override
    public boolean hasNext() {
        this._ensureNextAvailable();
        return -1 != this.m_nNext;
    }

    @Override
    public char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        this.m_bNextAvailable = false;
        return (char)this.m_nNext;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() is not supported here");
    }

    private void _ensureNextAvailable() {
        if (!this.m_bNextAvailable) {
            this._readNext();
        }
    }

    private void _readNext() {
        try {
            this.m_nNext = this.m_aReader.read();
            this.m_bNextAvailable = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Nullable
    public static CharIterator adapt(@Nullable Reader reader) {
        return null == reader ? null : new ReaderCharIterator(reader);
    }
}

