/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.sun.jersey.api.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebException;

@Provider
public class WebEngineExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    HttpHeaders headers;
    protected static final Log log = LogFactory.getLog(WebEngineExceptionMapper.class);

    public Response toResponse(Throwable cause) {
        if (cause instanceof NotFoundException) {
            NotFoundException nfe = (NotFoundException)cause;
            log.warn((Object)("JAX-RS 404 Not Found: " + nfe.getNotFoundUri()));
        } else {
            log.warn((Object)"Exception in JAX-RS processing", cause);
        }
        return WebException.newException(cause.getMessage(), (Throwable)((Object)WebException.wrap(cause))).toResponse();
    }
}

