/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerService;
import org.nuxeo.ecm.core.storage.binary.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class DBSRepositoryBase
implements DBSRepository {
    public static final String TYPE_ROOT = "Root";
    protected final boolean DEBUG_UUIDS = false;
    private static final String UUID_ZERO = "00000000-0000-0000-0000-000000000000";
    private static final String UUID_ZERO_DEBUG = "UUID_0";
    protected final String repositoryName;
    protected final BinaryManager binaryManager;
    public Map<Transaction, TransactionContext> transactionContexts = new ConcurrentHashMap<Transaction, TransactionContext>();

    public DBSRepositoryBase(String repositoryName) {
        this.repositoryName = repositoryName;
        this.binaryManager = this.newBinaryManager();
    }

    public void shutdown() {
        this.binaryManager.close();
    }

    public String getName() {
        return this.repositoryName;
    }

    public void initRoot() {
        try {
            Session session = this.getSession(null);
            Document root = session.importDocument(this.getRootId(), null, "", TYPE_ROOT, new HashMap());
            ACLImpl acl = new ACLImpl();
            acl.add((Object)new ACE("administrators", "Everything", true));
            acl.add((Object)new ACE("Administrator", "Everything", true));
            acl.add((Object)new ACE("members", "Read", true));
            ACPImpl acp = new ACPImpl();
            acp.addACL((ACL)acl);
            session.setACP(root, (ACP)acp, true);
            session.save();
            session.close();
            if (TransactionHelper.isTransactionActive()) {
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRootId() {
        return UUID_ZERO;
    }

    @Override
    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public BinaryManager newBinaryManager() {
        DefaultBinaryManager binaryManager = new DefaultBinaryManager();
        BinaryManagerDescriptor binaryManagerDescriptor = new BinaryManagerDescriptor();
        try {
            binaryManagerDescriptor.repositoryName = this.repositoryName;
            binaryManagerDescriptor.storePath = null;
            binaryManager.initialize(binaryManagerDescriptor);
            BinaryManagerService bms = (BinaryManagerService)Framework.getLocalService(BinaryManagerService.class);
            bms.addBinaryManager(binaryManagerDescriptor.repositoryName, (BinaryManager)binaryManager);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return binaryManager;
    }

    public int getActiveSessionsCount() {
        return 0;
    }

    public Session getSession(String sessionId) throws DocumentException {
        Transaction transaction;
        try {
            transaction = TransactionHelper.lookupTransactionManager().getTransaction();
            if (transaction != null && transaction.getStatus() != 0) {
                transaction = null;
            }
        }
        catch (NamingException | SystemException e) {
            transaction = null;
        }
        if (transaction == null) {
            return this.newSession(sessionId);
        }
        TransactionContext context = this.transactionContexts.get(transaction);
        if (context == null) {
            context = new TransactionContext(transaction, this.newSession(sessionId));
            context.init();
        }
        return context.newSession(sessionId);
    }

    protected DBSSession newSession(String sessionId) {
        return new DBSSession(this, sessionId);
    }

    public static class DBSSessionInvoker
    implements InvocationHandler {
        private static final String METHOD_HASHCODE = "hashCode";
        private static final String METHOD_EQUALS = "equals";
        private static final String METHOD_GETSESSIONID = "getSessionId";
        private static final String METHOD_CLOSE = "close";
        private static final String METHOD_ISLIVE = "isLive";
        protected final TransactionContext context;
        protected final String sessionId;
        protected boolean closed;

        public DBSSessionInvoker(TransactionContext context, String sessionId) {
            this.context = context;
            this.sessionId = sessionId;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals(METHOD_HASHCODE)) {
                return this.doHashCode();
            }
            if (methodName.equals(METHOD_EQUALS)) {
                return this.doEquals(args);
            }
            if (methodName.equals(METHOD_GETSESSIONID)) {
                return this.doGetSessionId();
            }
            if (methodName.equals(METHOD_CLOSE)) {
                return this.doClose(proxy);
            }
            if (methodName.equals(METHOD_ISLIVE)) {
                return this.doIsLive();
            }
            if (this.closed) {
                throw new DocumentException("Cannot use closed connection handle: " + this.sessionId);
            }
            try {
                return method.invoke((Object)this.context.baseSession, args);
            }
            catch (Throwable t) {
                Throwable te;
                if (t instanceof InvocationTargetException && (te = ((InvocationTargetException)t).getTargetException()) != null) {
                    t = te;
                }
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw t;
            }
        }

        protected Integer doHashCode() {
            return this.hashCode();
        }

        protected Boolean doEquals(Object[] args) {
            if (args.length != 1 || args[0] == null) {
                return Boolean.FALSE;
            }
            Object other = args[0];
            if (!Proxy.isProxyClass(other.getClass())) {
                return Boolean.FALSE;
            }
            InvocationHandler otherInvoker = Proxy.getInvocationHandler(other);
            return this.equals(otherInvoker);
        }

        protected String doGetSessionId() {
            return this.sessionId;
        }

        protected Object doClose(Object proxy) {
            this.closed = true;
            this.context.remove(proxy);
            return null;
        }

        protected Boolean doIsLive() {
            if (this.closed) {
                return Boolean.FALSE;
            }
            return this.context.baseSession.isLive();
        }
    }

    public class TransactionContext
    implements Synchronization {
        protected final Transaction transaction;
        protected final DBSSession baseSession;
        protected final Set<Session> proxies;

        public TransactionContext(Transaction transaction, DBSSession baseSession) {
            this.transaction = transaction;
            this.baseSession = baseSession;
            this.proxies = new HashSet<Session>();
        }

        public void init() {
            DBSRepositoryBase.this.transactionContexts.put(this.transaction, this);
            try {
                this.transaction.registerSynchronization((Synchronization)this);
            }
            catch (RollbackException | SystemException e) {
                throw new RuntimeException(e);
            }
        }

        public Session newSession(String sessionId) {
            ClassLoader cl = this.getClass().getClassLoader();
            DBSSessionInvoker invoker = new DBSSessionInvoker(this, sessionId);
            Session proxy = (Session)Proxy.newProxyInstance(cl, new Class[]{Session.class}, (InvocationHandler)invoker);
            this.add(proxy);
            return proxy;
        }

        public void add(Session proxy) {
            this.proxies.add(proxy);
        }

        public boolean remove(Object proxy) {
            return this.proxies.remove(proxy);
        }

        public void beforeCompletion() {
            try {
                this.baseSession.commit();
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }

        public void afterCompletion(int status) {
            this.baseSession.close();
            for (Session proxy : this.proxies.toArray(new Session[0])) {
                proxy.close();
            }
            DBSRepositoryBase.this.transactionContexts.remove(this.transaction);
        }
    }
}

