/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.service;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WIRequestFilter
implements Filter {
    public static String WEBDAV_USERAGENT = "Microsoft-WebDAV-MiniRedir";
    public static String MSOFFICE_USERAGENT = "Microsoft Office Existence Discovery";
    public static final String BACKEND_KEY = "org.nuxeo.ecm.webdav.service.backend";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!this.isWIRequest(httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        boolean txStarted = false;
        boolean ok = false;
        try {
            if (!TransactionHelper.isTransactionActive()) {
                txStarted = TransactionHelper.startTransaction();
                if (!txStarted) {
                    throw new ServletException("A transaction is needed.");
                }
                response = new BufferingHttpServletResponse(httpResponse);
            }
            chain.doFilter(request, response);
            ok = true;
        }
        finally {
            if (txStarted) {
                try {
                    if (!ok) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
                finally {
                    ((BufferingHttpServletResponse)response).stopBuffering();
                }
            }
        }
    }

    public void destroy() {
    }

    private boolean isWIRequest(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return StringUtils.isNotEmpty((String)ua) && (ua.contains(WEBDAV_USERAGENT) || ua.contains(MSOFFICE_USERAGENT));
    }
}

