/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.keys;

import java.util.UUID;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.keys.OAuthServerKeyManager;
import org.nuxeo.ecm.platform.oauth.keys.ServerKeyDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthServerKeyManagerImpl
extends DefaultComponent
implements OAuthServerKeyManager {
    protected ServerKeyDescriptor serverKeyDescriptor;
    public static final String XP_SERVER_KEY = "serverKeyPair";
    protected NuxeoOAuthConsumer consumer;
    protected String internalKey;
    protected String internalSecret;

    public void activate(ComponentContext context) throws Exception {
        this.internalKey = "nuxeo4shindig-" + UUID.randomUUID().toString();
        this.internalSecret = UUID.randomUUID().toString();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_SERVER_KEY.equals(extensionPoint)) {
            this.serverKeyDescriptor = (ServerKeyDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_SERVER_KEY.equals(extensionPoint)) {
            this.serverKeyDescriptor = null;
        }
    }

    @Override
    public String getPublicKeyCertificate() {
        if (this.serverKeyDescriptor != null) {
            return this.serverKeyDescriptor.externalPublicCertificate;
        }
        return null;
    }

    @Override
    public String getBarePublicCertificate() {
        return this.stripOpenSSL(this.getPublicKeyCertificate());
    }

    @Override
    public String getPrivateKey() {
        if (this.serverKeyDescriptor != null) {
            return this.serverKeyDescriptor.externalPrivateKey;
        }
        return null;
    }

    @Override
    public String getBarePrivateKey() {
        return this.stripOpenSSL(this.getPrivateKey());
    }

    @Override
    public String getKeyName() {
        if (this.serverKeyDescriptor != null) {
            return this.serverKeyDescriptor.externalPrivateKeyName;
        }
        return null;
    }

    protected String stripOpenSSL(String key) {
        if (key == null) {
            return null;
        }
        return key.replaceAll("-----[A-Z ]*-----", "").replace("\n", "");
    }

    @Override
    public String getInternalKey() {
        return this.internalKey;
    }

    @Override
    public String getInternalSecret() {
        return this.internalSecret;
    }

    @Override
    public NuxeoOAuthConsumer getInternalConsumer() {
        if (this.consumer == null) {
            this.consumer = new InternalNuxeoOAuthConsumer(this.internalKey, this.internalSecret);
        }
        return this.consumer;
    }

    protected class InternalNuxeoOAuthConsumer
    extends NuxeoOAuthConsumer {
        private static final long serialVersionUID = 1L;

        public InternalNuxeoOAuthConsumer(String consumerKey, String consumerSecret) {
            super(null, consumerKey, consumerSecret, null);
            this.signedFetchSupport = "opensocial:viewer";
        }
    }
}

